/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.IntWritable;

@Description(name="size", value="_FUNC_(a) - Returns the size of a")
public class GenericUDFSize
extends GenericUDF {
    private transient ObjectInspector returnOI;
    private final transient IntWritable result = new IntWritable(-1);

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentLengthException("The function SIZE only accepts 1 argument.");
        }
        ObjectInspector.Category category = arguments[0].getCategory();
        String typeName = arguments[0].getTypeName();
        if (category != ObjectInspector.Category.MAP && category != ObjectInspector.Category.LIST && !typeName.equals("void")) {
            throw new UDFArgumentTypeException(0, "\"" + ObjectInspector.Category.MAP.toString().toLowerCase() + "\" or \"" + ObjectInspector.Category.LIST.toString().toLowerCase() + "\" is expected at function SIZE, " + "but \"" + arguments[0].getTypeName() + "\" is found");
        }
        this.returnOI = arguments[0];
        return PrimitiveObjectInspectorFactory.writableIntObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object data = arguments[0].get();
        if (this.returnOI.getCategory() == ObjectInspector.Category.MAP) {
            this.result.set(((MapObjectInspector)this.returnOI).getMapSize(data));
        } else if (this.returnOI.getCategory() == ObjectInspector.Category.LIST) {
            this.result.set(((ListObjectInspector)this.returnOI).getListLength(data));
        } else if (this.returnOI.getTypeName().equals("void")) {
            this.result.set(-1);
        }
        return this.result;
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 1);
        return this.getStandardDisplayString("size", children);
    }
}

