/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tutorial;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pig.FilterFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonURLDetector
extends FilterFunc {
    private Pattern _urlPattern = Pattern.compile("^[\"]?(http[:|;])|(https[:|;])|(www\\.)");

    public Boolean exec(Tuple tuple) throws IOException {
        String string;
        if (tuple == null || tuple.size() == 0) {
            return false;
        }
        try {
            string = (String)tuple.get(0);
            if (string == null) {
                return false;
            }
            string = string.trim();
        }
        catch (Exception exception) {
            System.err.println("NonURLDetector: failed to process input; error - " + exception.getMessage());
            return false;
        }
        if (string.equals("")) {
            return false;
        }
        Matcher matcher = this._urlPattern.matcher(string);
        if (matcher.find()) {
            return false;
        }
        return true;
    }

    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> arrayList = new ArrayList<FuncSpec>();
        arrayList.add(new FuncSpec(((Object)((Object)this)).getClass().getName(), new Schema(new Schema.FieldSchema(null, 55))));
        return arrayList;
    }
}

