/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.start.classloader.vfs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.FileReplicator;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponent;
import org.apache.commons.vfs2.provider.VfsComponentContext;

public class UniqueFileReplicator
implements VfsComponent,
FileReplicator {
    private static final char[] TMP_RESERVED_CHARS = new char[]{'?', '/', '\\', ' ', '&', '\"', '\'', '*', '#', ';', ':', '<', '>', '|'};
    private File tempDir;
    private VfsComponentContext context;
    private List<File> tmpFiles = Collections.synchronizedList(new ArrayList());

    public UniqueFileReplicator(File tempDir) {
        this.tempDir = tempDir;
    }

    public File replicateFile(FileObject srcFile, FileSelector selector) throws FileSystemException {
        String baseName = srcFile.getName().getBaseName();
        try {
            this.tempDir.mkdirs();
            String safeBasename = UriParser.encode((String)baseName, (char[])TMP_RESERVED_CHARS).replace('%', '_');
            File file = File.createTempFile("vfsr_", "_" + safeBasename, this.tempDir);
            file.deleteOnExit();
            FileObject destFile = this.context.toFileObject(file);
            destFile.copyFrom(srcFile, selector);
            return file;
        }
        catch (IOException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    public void setLogger(Log logger) {
    }

    public void setContext(VfsComponentContext context) {
        this.context = context;
    }

    public void init() throws FileSystemException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        List<File> list = this.tmpFiles;
        synchronized (list) {
            for (File tmpFile : this.tmpFiles) {
                tmpFile.delete();
            }
        }
        this.tempDir.delete();
    }
}

