/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.AccessControlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileSystemContractBaseTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemContractBaseTest.class);
    protected static final String TEST_UMASK = "062";
    protected FileSystem fs;
    protected byte[] data = this.dataset(this.getBlockSize() * 2, 0, 255);

    protected void tearDown() throws Exception {
        if (this.fs != null) {
            if (this.rootDirTestEnabled()) {
                this.cleanupDir(this.path("/FileSystemContractBaseTest"));
            }
            this.cleanupDir(this.getTestBaseDir());
        }
        super.tearDown();
    }

    private void cleanupDir(Path p) {
        try {
            LOG.info("Deleting " + p);
            this.fs.delete(p, true);
        }
        catch (IOException e) {
            LOG.error("Error deleting test dir: " + p, (Throwable)e);
        }
    }

    protected Path getTestBaseDir() {
        return new Path(this.fs.getWorkingDirectory(), "FileSystemContractBaseTest");
    }

    protected final Path path(String pathString) {
        Path p = new Path(pathString).makeQualified(this.fs.getUri(), this.getTestBaseDir());
        LOG.info("Resolving {} -> {}", (Object)pathString, (Object)p);
        return p;
    }

    protected int getBlockSize() {
        return 1024;
    }

    protected String getDefaultWorkingDirectory() {
        return "/user/" + System.getProperty("user.name");
    }

    protected boolean renameSupported() {
        return true;
    }

    protected boolean rootDirTestEnabled() {
        return true;
    }

    public void testFsStatus() throws Exception {
        FsStatus fsStatus = this.fs.getStatus();
        FileSystemContractBaseTest.assertNotNull((Object)fsStatus);
        FileSystemContractBaseTest.assertTrue((fsStatus.getUsed() >= 0L ? 1 : 0) != 0);
        FileSystemContractBaseTest.assertTrue((fsStatus.getRemaining() >= 0L ? 1 : 0) != 0);
        FileSystemContractBaseTest.assertTrue((fsStatus.getCapacity() >= 0L ? 1 : 0) != 0);
    }

    public void testWorkingDirectory() throws Exception {
        Path workDir = this.path(this.getDefaultWorkingDirectory());
        FileSystemContractBaseTest.assertEquals((Object)workDir, (Object)this.fs.getWorkingDirectory());
        this.fs.setWorkingDirectory(this.fs.makeQualified(new Path(".")));
        FileSystemContractBaseTest.assertEquals((Object)workDir, (Object)this.fs.getWorkingDirectory());
        this.fs.setWorkingDirectory(this.fs.makeQualified(new Path("..")));
        FileSystemContractBaseTest.assertEquals((Object)workDir.getParent(), (Object)this.fs.getWorkingDirectory());
        Path relativeDir = this.fs.makeQualified(new Path("testWorkingDirectory"));
        this.fs.setWorkingDirectory(relativeDir);
        FileSystemContractBaseTest.assertEquals((Object)relativeDir, (Object)this.fs.getWorkingDirectory());
        Path absoluteDir = this.path("/FileSystemContractBaseTest/testWorkingDirectory");
        this.fs.setWorkingDirectory(absoluteDir);
        FileSystemContractBaseTest.assertEquals((Object)absoluteDir, (Object)this.fs.getWorkingDirectory());
    }

    public void testMkdirs() throws Exception {
        Path testDir = this.path("testMkdirs");
        FileSystemContractBaseTest.assertFalse((boolean)this.fs.exists(testDir));
        FileSystemContractBaseTest.assertFalse((boolean)this.fs.isFile(testDir));
        FileSystemContractBaseTest.assertTrue((boolean)this.fs.mkdirs(testDir));
        FileSystemContractBaseTest.assertTrue((boolean)this.fs.exists(testDir));
        FileSystemContractBaseTest.assertFalse((boolean)this.fs.isFile(testDir));
        FileSystemContractBaseTest.assertTrue((boolean)this.fs.mkdirs(testDir));
        FileSystemContractBaseTest.assertTrue((boolean)this.fs.exists(testDir));
        FileSystemContractBaseTest.assertFalse((boolean)this.fs.isFile(testDir));
        Path parentDir = testDir.getParent();
        FileSystemContractBaseTest.assertTrue((boolean)this.fs.exists(parentDir));
        FileSystemContractBaseTest.assertFalse((boolean)this.fs.isFile(parentDir));
        Path grandparentDir = parentDir.getParent();
        FileSystemContractBaseTest.assertTrue((boolean)this.fs.exists(grandparentDir));
        FileSystemContractBaseTest.assertFalse((boolean)this.fs.isFile(grandparentDir));
    }

    public void testMkdirsFailsForSubdirectoryOfExistingFile() throws Exception {
        Path testDir = this.path("testMkdirsFailsForSubdirectoryOfExistingFile");
        FileSystemContractBaseTest.assertFalse((boolean)this.fs.exists(testDir));
        FileSystemContractBaseTest.assertTrue((boolean)this.fs.mkdirs(testDir));
        FileSystemContractBaseTest.assertTrue((boolean)this.fs.exists(testDir));
        this.createFile(this.path("testMkdirsFailsForSubdirectoryOfExistingFile/file"));
        Path testSubDir = this.path("testMkdirsFailsForSubdirectoryOfExistingFile/file/subdir");
        try {
            this.fs.mkdirs(testSubDir);
            FileSystemContractBaseTest.fail((String)"Should throw IOException.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            FileSystemContractBaseTest.assertFalse((boolean)this.fs.exists(testSubDir));
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        Path testDeepSubDir = this.path("testMkdirsFailsForSubdirectoryOfExistingFile/file/deep/sub/dir");
        try {
            this.fs.mkdirs(testDeepSubDir);
            FileSystemContractBaseTest.fail((String)"Should throw IOException.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            FileSystemContractBaseTest.assertFalse((boolean)this.fs.exists(testDeepSubDir));
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMkdirsWithUmask() throws Exception {
        if (this.fs.getScheme().equals("s3") || this.fs.getScheme().equals("s3n")) {
            return;
        }
        Configuration conf = this.fs.getConf();
        String oldUmask = conf.get("fs.permissions.umask-mode");
        try {
            conf.set("fs.permissions.umask-mode", TEST_UMASK);
            Path dir = new Path("newDir");
            FileSystemContractBaseTest.assertTrue((boolean)this.fs.mkdirs(dir, new FsPermission(511)));
            FileStatus status = this.fs.getFileStatus(dir);
            FileSystemContractBaseTest.assertTrue((boolean)status.isDirectory());
            FileSystemContractBaseTest.assertEquals((short)461, (short)status.getPermission().toShort());
        }
        finally {
            conf.set("fs.permissions.umask-mode", oldUmask);
        }
    }

    public void testGetFileStatusThrowsExceptionForNonExistentFile() throws Exception {
        try {
            this.fs.getFileStatus(this.path("testGetFileStatusThrowsExceptionForNonExistentFile/file"));
            FileSystemContractBaseTest.fail((String)"Should throw FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void testListStatusThrowsExceptionForNonExistentFile() throws Exception {
        try {
            this.fs.listStatus(this.path("testListStatusThrowsExceptionForNonExistentFile/file"));
            FileSystemContractBaseTest.fail((String)"Should throw FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void testListStatus() throws Exception {
        Path[] testDirs = new Path[]{this.path("testListStatus/a"), this.path("testListStatus/b"), this.path("testListStatus/c/1")};
        FileSystemContractBaseTest.assertFalse((boolean)this.fs.exists(testDirs[0]));
        for (Path path : testDirs) {
            FileSystemContractBaseTest.assertTrue((boolean)this.fs.mkdirs(path));
        }
        FileStatus[] paths = this.fs.listStatus(this.path("."));
        FileSystemContractBaseTest.assertEquals((int)1, (int)paths.length);
        FileSystemContractBaseTest.assertEquals((Object)this.path("testListStatus"), (Object)paths[0].getPath());
        paths = this.fs.listStatus(this.path("testListStatus"));
        FileSystemContractBaseTest.assertEquals((int)3, (int)paths.length);
        ArrayList<Path> list = new ArrayList<Path>();
        for (FileStatus fileState : paths) {
            list.add(fileState.getPath());
        }
        FileSystemContractBaseTest.assertTrue((boolean)list.contains(this.path("testListStatus/a")));
        FileSystemContractBaseTest.assertTrue((boolean)list.contains(this.path("testListStatus/b")));
        FileSystemContractBaseTest.assertTrue((boolean)list.contains(this.path("testListStatus/c")));
        paths = this.fs.listStatus(this.path("testListStatus/a"));
        FileSystemContractBaseTest.assertEquals((int)0, (int)paths.length);
    }

    public void testWriteReadAndDeleteEmptyFile() throws Exception {
        this.writeReadAndDelete(0);
    }

    public void testWriteReadAndDeleteHalfABlock() throws Exception {
        this.writeReadAndDelete(this.getBlockSize() / 2);
    }

    public void testWriteReadAndDeleteOneBlock() throws Exception {
        this.writeReadAndDelete(this.getBlockSize());
    }

    public void testWriteReadAndDeleteOneAndAHalfBlocks() throws Exception {
        this.writeReadAndDelete(this.getBlockSize() + this.getBlockSize() / 2);
    }

    public void testWriteReadAndDeleteTwoBlocks() throws Exception {
        this.writeReadAndDelete(this.getBlockSize() * 2);
    }

    protected void writeReadAndDelete(int len) throws IOException {
        Path path = this.path("writeReadAndDelete/file");
        this.writeAndRead(path, this.data, len, false, true);
    }

    public void testOverwrite() throws IOException {
        Path path = this.path("testOverwrite/file");
        this.fs.mkdirs(path.getParent());
        this.createFile(path);
        FileSystemContractBaseTest.assertTrue((String)"Exists", (boolean)this.fs.exists(path));
        FileSystemContractBaseTest.assertEquals((String)"Length", (long)this.data.length, (long)this.fs.getFileStatus(path).getLen());
        try {
            this.fs.create(path, false).close();
            FileSystemContractBaseTest.fail((String)"Should throw IOException.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FSDataOutputStream out = this.fs.create(path, true);
        out.write(this.data, 0, this.data.length);
        out.close();
        FileSystemContractBaseTest.assertTrue((String)"Exists", (boolean)this.fs.exists(path));
        FileSystemContractBaseTest.assertEquals((String)"Length", (long)this.data.length, (long)this.fs.getFileStatus(path).getLen());
    }

    public void testWriteInNonExistentDirectory() throws IOException {
        Path path = this.path("testWriteInNonExistentDirectory/file");
        FileSystemContractBaseTest.assertFalse((String)"Parent exists", (boolean)this.fs.exists(path.getParent()));
        this.createFile(path);
        FileSystemContractBaseTest.assertTrue((String)"Exists", (boolean)this.fs.exists(path));
        FileSystemContractBaseTest.assertEquals((String)"Length", (long)this.data.length, (long)this.fs.getFileStatus(path).getLen());
        FileSystemContractBaseTest.assertTrue((String)"Parent exists", (boolean)this.fs.exists(path.getParent()));
    }

    public void testDeleteNonExistentFile() throws IOException {
        Path path = this.path("testDeleteNonExistentFile/file");
        FileSystemContractBaseTest.assertFalse((String)("Path exists: " + path), (boolean)this.fs.exists(path));
        FileSystemContractBaseTest.assertFalse((String)"No deletion", (boolean)this.fs.delete(path, true));
    }

    public void testDeleteRecursively() throws IOException {
        Path dir = this.path("testDeleteRecursively");
        Path file = this.path("testDeleteRecursively/file");
        Path subdir = this.path("testDeleteRecursively/subdir");
        this.createFile(file);
        FileSystemContractBaseTest.assertTrue((String)"Created subdir", (boolean)this.fs.mkdirs(subdir));
        FileSystemContractBaseTest.assertTrue((String)"File exists", (boolean)this.fs.exists(file));
        FileSystemContractBaseTest.assertTrue((String)"Dir exists", (boolean)this.fs.exists(dir));
        FileSystemContractBaseTest.assertTrue((String)"Subdir exists", (boolean)this.fs.exists(subdir));
        try {
            this.fs.delete(dir, false);
            FileSystemContractBaseTest.fail((String)"Should throw IOException.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FileSystemContractBaseTest.assertTrue((String)"File still exists", (boolean)this.fs.exists(file));
        FileSystemContractBaseTest.assertTrue((String)"Dir still exists", (boolean)this.fs.exists(dir));
        FileSystemContractBaseTest.assertTrue((String)"Subdir still exists", (boolean)this.fs.exists(subdir));
        FileSystemContractBaseTest.assertTrue((String)"Deleted", (boolean)this.fs.delete(dir, true));
        FileSystemContractBaseTest.assertFalse((String)"File doesn't exist", (boolean)this.fs.exists(file));
        FileSystemContractBaseTest.assertFalse((String)"Dir doesn't exist", (boolean)this.fs.exists(dir));
        FileSystemContractBaseTest.assertFalse((String)"Subdir doesn't exist", (boolean)this.fs.exists(subdir));
    }

    public void testDeleteEmptyDirectory() throws IOException {
        Path dir = this.path("testDeleteEmptyDirectory");
        FileSystemContractBaseTest.assertTrue((boolean)this.fs.mkdirs(dir));
        FileSystemContractBaseTest.assertTrue((String)"Dir exists", (boolean)this.fs.exists(dir));
        FileSystemContractBaseTest.assertTrue((String)"Deleted", (boolean)this.fs.delete(dir, false));
        FileSystemContractBaseTest.assertFalse((String)"Dir doesn't exist", (boolean)this.fs.exists(dir));
    }

    public void testRenameNonExistentPath() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.path("testRenameNonExistentPath/path");
        Path dst = this.path("testRenameNonExistentPathNew/newpath");
        this.rename(src, dst, false, false, false);
    }

    public void testRenameFileMoveToNonExistentDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.path("testRenameFileMoveToNonExistentDirectory/file");
        this.createFile(src);
        Path dst = this.path("testRenameFileMoveToNonExistentDirectoryNew/newfile");
        this.rename(src, dst, false, true, false);
    }

    public void testRenameFileMoveToExistingDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.path("testRenameFileMoveToExistingDirectory/file");
        this.createFile(src);
        Path dst = this.path("testRenameFileMoveToExistingDirectoryNew/newfile");
        this.fs.mkdirs(dst.getParent());
        this.rename(src, dst, true, false, true);
    }

    public void testRenameFileAsExistingFile() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.path("testRenameFileAsExistingFile/file");
        this.createFile(src);
        Path dst = this.path("testRenameFileAsExistingFileNew/newfile");
        this.createFile(dst);
        this.rename(src, dst, false, true, true);
    }

    public void testRenameFileAsExistingDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.path("testRenameFileAsExistingDirectory/file");
        this.createFile(src);
        Path dst = this.path("testRenameFileAsExistingDirectoryNew/newdir");
        this.fs.mkdirs(dst);
        this.rename(src, dst, true, false, true);
        FileSystemContractBaseTest.assertTrue((String)"Destination changed", (boolean)this.fs.exists(this.path("testRenameFileAsExistingDirectoryNew/newdir/file")));
    }

    public void testRenameDirectoryMoveToNonExistentDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.path("testRenameDirectoryMoveToNonExistentDirectory/dir");
        this.fs.mkdirs(src);
        Path dst = this.path("testRenameDirectoryMoveToNonExistentDirectoryNew/newdir");
        this.rename(src, dst, false, true, false);
    }

    public void testRenameDirectoryMoveToExistingDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.path("testRenameDirectoryMoveToExistingDirectory/dir");
        this.fs.mkdirs(src);
        this.createFile(this.path(src + "/file1"));
        this.createFile(this.path(src + "/subdir/file2"));
        Path dst = this.path("testRenameDirectoryMoveToExistingDirectoryNew/newdir");
        this.fs.mkdirs(dst.getParent());
        this.rename(src, dst, true, false, true);
        FileSystemContractBaseTest.assertFalse((String)"Nested file1 exists", (boolean)this.fs.exists(this.path(src + "/file1")));
        FileSystemContractBaseTest.assertFalse((String)"Nested file2 exists", (boolean)this.fs.exists(this.path(src + "/subdir/file2")));
        FileSystemContractBaseTest.assertTrue((String)"Renamed nested file1 exists", (boolean)this.fs.exists(this.path(dst + "/file1")));
        FileSystemContractBaseTest.assertTrue((String)"Renamed nested exists", (boolean)this.fs.exists(this.path(dst + "/subdir/file2")));
    }

    public void testRenameDirectoryAsExistingFile() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.path("testRenameDirectoryAsExistingFile/dir");
        this.fs.mkdirs(src);
        Path dst = this.path("testRenameDirectoryAsExistingFileNew/newfile");
        this.createFile(dst);
        this.rename(src, dst, false, true, true);
    }

    public void testRenameDirectoryAsExistingDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.path("testRenameDirectoryAsExistingDirectory/dir");
        this.fs.mkdirs(src);
        this.createFile(this.path(src + "/file1"));
        this.createFile(this.path(src + "/subdir/file2"));
        Path dst = this.path("testRenameDirectoryAsExistingDirectoryNew/newdir");
        this.fs.mkdirs(dst);
        this.rename(src, dst, true, false, true);
        FileSystemContractBaseTest.assertTrue((String)"Destination changed", (boolean)this.fs.exists(this.path(dst + "/dir")));
        FileSystemContractBaseTest.assertFalse((String)"Nested file1 exists", (boolean)this.fs.exists(this.path(src + "/file1")));
        FileSystemContractBaseTest.assertFalse((String)"Nested file2 exists", (boolean)this.fs.exists(this.path(src + "r/subdir/file2")));
        FileSystemContractBaseTest.assertTrue((String)"Renamed nested file1 exists", (boolean)this.fs.exists(this.path(dst + "/dir/file1")));
        FileSystemContractBaseTest.assertTrue((String)"Renamed nested exists", (boolean)this.fs.exists(this.path(dst + "/dir/subdir/file2")));
    }

    public void testInputStreamClosedTwice() throws IOException {
        Path src = this.path("testInputStreamClosedTwice/file");
        this.createFile(src);
        FSDataInputStream in = this.fs.open(src);
        in.close();
        in.close();
    }

    public void testOutputStreamClosedTwice() throws IOException {
        Path src = this.path("testOutputStreamClosedTwice/file");
        FSDataOutputStream out = this.fs.create(src);
        out.writeChar(72);
        out.close();
        out.close();
    }

    protected void createFile(Path path) throws IOException {
        FSDataOutputStream out = this.fs.create(path);
        out.write(this.data, 0, this.data.length);
        out.close();
    }

    protected void rename(Path src, Path dst, boolean renameSucceeded, boolean srcExists, boolean dstExists) throws IOException {
        FileSystemContractBaseTest.assertEquals((String)"Rename result", (boolean)renameSucceeded, (boolean)this.fs.rename(src, dst));
        FileSystemContractBaseTest.assertEquals((String)"Source exists", (boolean)srcExists, (boolean)this.fs.exists(src));
        FileSystemContractBaseTest.assertEquals((String)("Destination exists" + dst), (boolean)dstExists, (boolean)this.fs.exists(dst));
    }

    public void testOverWriteAndRead() throws Exception {
        int blockSize = this.getBlockSize();
        byte[] filedata1 = this.dataset(blockSize * 2, 65, 26);
        byte[] filedata2 = this.dataset(blockSize * 2, 97, 26);
        Path path = this.path("testOverWriteAndRead/file-overwrite");
        this.writeAndRead(path, filedata1, blockSize, true, false);
        this.writeAndRead(path, filedata2, blockSize, true, false);
        this.writeAndRead(path, filedata1, blockSize * 2, true, false);
        this.writeAndRead(path, filedata2, blockSize * 2, true, false);
        this.writeAndRead(path, filedata1, blockSize, true, false);
        this.writeAndRead(path, filedata2, blockSize * 2, true, false);
    }

    protected void writeAndRead(Path path, byte[] src, int len, boolean overwrite, boolean delete) throws IOException {
        FileSystemContractBaseTest.assertTrue((String)("Not enough data in source array to write " + len + " bytes"), (src.length >= len ? 1 : 0) != 0);
        this.fs.mkdirs(path.getParent());
        FSDataOutputStream out = this.fs.create(path, overwrite, this.fs.getConf().getInt("io.file.buffer.size", 4096), (short)1, (long)this.getBlockSize());
        out.write(src, 0, len);
        out.close();
        FileSystemContractBaseTest.assertTrue((String)"Exists", (boolean)this.fs.exists(path));
        FileSystemContractBaseTest.assertEquals((String)"Length", (long)len, (long)this.fs.getFileStatus(path).getLen());
        FSDataInputStream in = this.fs.open(path);
        byte[] buf = new byte[len];
        in.readFully(0L, buf);
        in.close();
        FileSystemContractBaseTest.assertEquals((int)len, (int)buf.length);
        int errors = 0;
        int first_error_byte = -1;
        for (int i = 0; i < len; ++i) {
            if (src[i] == buf[i]) continue;
            if (errors == 0) {
                first_error_byte = i;
            }
            ++errors;
        }
        if (errors > 0) {
            String message = String.format(" %d errors in file of length %d", errors, len);
            LOG.warn(message);
            int overlap = 10;
            for (int i = Math.max(0, first_error_byte - 10); i < Math.min(first_error_byte + 10, len); ++i) {
                byte actual = buf[i];
                byte expected = src[i];
                String letter = this.toChar(actual);
                String line = String.format("[%04d] %2x %s\n", i, actual, letter);
                if (expected != actual) {
                    line = String.format("[%04d] %2x %s -expected %2x %s\n", i, actual, letter, expected, this.toChar(expected));
                }
                LOG.warn(line);
            }
            FileSystemContractBaseTest.fail((String)message);
        }
        if (delete) {
            boolean deleted = this.fs.delete(path, false);
            FileSystemContractBaseTest.assertTrue((String)"Deleted", (boolean)deleted);
            FileSystemContractBaseTest.assertFalse((String)"No longer exists", (boolean)this.fs.exists(path));
        }
    }

    protected String toChar(byte b) {
        if (b >= 32) {
            return Character.toString((char)b);
        }
        return String.format("%02x", b);
    }

    protected byte[] dataset(int len, int base, int modulo) {
        byte[] dataset = new byte[len];
        for (int i = 0; i < len; ++i) {
            dataset[i] = (byte)(base + i % modulo);
        }
        return dataset;
    }
}

