/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.pig.impl.util.Pair;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.mapreduce.hadoop.InputSplitInfo;
import org.apache.tez.mapreduce.hadoop.InputSplitInfoMem;
import org.apache.tez.mapreduce.hadoop.MRInputHelpers;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;

public class TezInputHelper {
    private static final Log LOG = LogFactory.getLog(TezInputHelper.class);

    public static InputSplitInfoMem generateInputSplitsToMem(Configuration conf) throws IOException, ClassNotFoundException, InterruptedException {
        InputSplitInfoMem splitInfoMem = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Generating mapreduce api input splits");
        }
        Job job = Job.getInstance((Configuration)conf);
        InputSplit[] splits = TezInputHelper.generateSplits((JobContext)job);
        splitInfoMem = new InputSplitInfoMem(splits, TezInputHelper.createTaskLocationHintsFromSplits(splits), splits.length, job.getCredentials(), job.getConfiguration());
        return splitInfoMem;
    }

    private static InputSplit[] generateSplits(JobContext jobContext) throws ClassNotFoundException, IOException, InterruptedException {
        Configuration conf = jobContext.getConfiguration();
        InputFormat inputFormat = null;
        try {
            inputFormat = (InputFormat)ReflectionUtils.newInstance((Class)jobContext.getInputFormatClass(), (Configuration)conf);
        }
        catch (ClassNotFoundException e) {
            throw new TezUncheckedException((Throwable)e);
        }
        InputFormat finalInputFormat = inputFormat;
        List array = finalInputFormat.getSplits(jobContext);
        InputSplit[] splits = array.toArray(new InputSplit[array.size()]);
        Arrays.sort(splits, new InputSplitComparator());
        return splits;
    }

    private static List<TaskLocationHint> createTaskLocationHintsFromSplits(InputSplit[] newFormatSplits) throws IOException, InterruptedException {
        ArrayList<TaskLocationHint> listLocationHint = new ArrayList<TaskLocationHint>(newFormatSplits.length);
        for (InputSplit input : newFormatSplits) {
            listLocationHint.add(TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList(input.getLocations())), null));
        }
        return listLocationHint;
    }

    public static Pair<Long, Boolean> createSplitsProto(InputSplitInfo inputSplitInfo, Configuration conf, MRRuntimeProtos.MRSplitsProto.Builder splitsBuilder, long spillThreshold) {
        try {
            return TezInputHelper.createSplitsProto(inputSplitInfo.getNewFormatSplits(), new SerializationFactory(conf), splitsBuilder, spillThreshold);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static Pair<Long, Boolean> createSplitsProto(InputSplit[] inputSplits, SerializationFactory serializationFactory, MRRuntimeProtos.MRSplitsProto.Builder splitsBuilder, long spillThreshold) throws IOException, InterruptedException {
        MRRuntimeProtos.MRSplitProto split = null;
        long serializedSize = 0L;
        boolean allSerialized = true;
        for (int i = 0; i < inputSplits.length; ++i) {
            split = MRInputHelpers.createSplitProto((InputSplit)inputSplits[i], (SerializationFactory)serializationFactory);
            splitsBuilder.addSplits(split);
            if ((serializedSize += (long)split.getSerializedSize()) <= spillThreshold || i == inputSplits.length - 1) continue;
            allSerialized = false;
            break;
        }
        return new Pair<Long, Boolean>(serializedSize, allSerialized);
    }

    private static class InputSplitComparator
    implements Comparator<InputSplit> {
        private InputSplitComparator() {
        }

        @Override
        public int compare(InputSplit o1, InputSplit o2) {
            try {
                long len1 = o1.getLength();
                long len2 = o2.getLength();
                if (len1 < len2) {
                    return 1;
                }
                if (len1 == len2) {
                    return 0;
                }
                return -1;
            }
            catch (IOException ie) {
                throw new RuntimeException("exception in InputSplit compare", ie);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException("exception in InputSplit compare", ie);
            }
        }
    }
}

