/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.tabletserver.metrics;

import javax.management.ObjectName;
import org.apache.accumulo.server.metrics.AbstractMetricsImpl;
import org.apache.accumulo.server.tabletserver.metrics.TabletServerMinCMetricsMBean;
import org.apache.log4j.Logger;

public class TabletServerMinCMetrics
extends AbstractMetricsImpl
implements TabletServerMinCMetricsMBean {
    static final Logger log = Logger.getLogger(TabletServerMinCMetrics.class);
    private static final String METRICS_PREFIX = "tserver.minc";
    private static ObjectName OBJECT_NAME = null;

    public TabletServerMinCMetrics() {
        this.reset();
        try {
            OBJECT_NAME = new ObjectName("accumulo.server.metrics:service=TServerInfo,name=TabletServerMinCMetricsMBean,instance=" + Thread.currentThread().getName());
        }
        catch (Exception e) {
            log.error((Object)"Exception setting MBean object name", (Throwable)e);
        }
    }

    @Override
    protected ObjectName getObjectName() {
        return OBJECT_NAME;
    }

    @Override
    protected String getMetricsPrefix() {
        return METRICS_PREFIX;
    }

    @Override
    public long getMinorCompactionMinTime() {
        return this.getMetricMin("minc");
    }

    @Override
    public long getMinorCompactionAvgTime() {
        return this.getMetricAvg("minc");
    }

    @Override
    public long getMinorCompactionCount() {
        return this.getMetricCount("minc");
    }

    @Override
    public long getMinorCompactionMaxTime() {
        return this.getMetricMax("minc");
    }

    @Override
    public long getMinorCompactionQueueAvgTime() {
        return this.getMetricAvg("queue");
    }

    @Override
    public long getMinorCompactionQueueCount() {
        return this.getMetricCount("queue");
    }

    @Override
    public long getMinorCompactionQueueMaxTime() {
        return this.getMetricMax("queue");
    }

    @Override
    public long getMinorCompactionQueueMinTime() {
        return this.getMetricMin("minc");
    }

    @Override
    public void reset() {
        this.createMetric("minc");
        this.createMetric("queue");
    }
}

