/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.tableOps;

import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.master.state.tables.TableManager;
import org.apache.accumulo.server.master.tableOps.CloneInfo;
import org.apache.accumulo.server.master.tableOps.MasterRepo;
import org.apache.accumulo.server.master.tableOps.Utils;
import org.apache.log4j.Logger;

class FinishCloneTable
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private CloneInfo cloneInfo;

    public FinishCloneTable(CloneInfo cloneInfo) {
        this.cloneInfo = cloneInfo;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return 0L;
    }

    @Override
    public Repo<Master> call(long tid, Master environment) throws Exception {
        TableManager.getInstance().transitionTableState(this.cloneInfo.tableId, TableState.ONLINE);
        Utils.unreserveTable(this.cloneInfo.srcTableId, tid, false);
        Utils.unreserveTable(this.cloneInfo.tableId, tid, true);
        environment.getEventCoordinator().event("Cloned table %s from %s", this.cloneInfo.tableName, this.cloneInfo.srcTableId);
        Logger.getLogger(FinishCloneTable.class).debug((Object)("Cloned table " + this.cloneInfo.srcTableId + " " + this.cloneInfo.tableId + " " + this.cloneInfo.tableName));
        return null;
    }

    @Override
    public void undo(long tid, Master environment) throws Exception {
    }
}

