/*
 * Decompiled with CFR 0.152.
 */
package sdsu.algorithms.data;

import sdsu.algorithms.data.NoInverseDistribution;
import sdsu.algorithms.data.OutOfBoundsException;

public class Zipf
extends NoInverseDistribution {
    private double harmonic;

    public Zipf(int n) {
        if (n <= 0) {
            throw new OutOfBoundsException("populationSize must be greater than 0, your value was " + n);
        }
        this.populationSize = n;
        this.harmonic = this.computeHarmonic(n);
        this.computePartialCumulativeDist(Math.min(25, n));
    }

    double computeHarmonic(int n) {
        double d = 0.0;
        int n2 = 1;
        while (n2 <= n) {
            d += 1.0 / (double)n2;
            ++n2;
        }
        return d;
    }

    public double density(double d) throws OutOfBoundsException {
        int n = (int)d;
        if (n <= 0 || n > this.populationSize) {
            throw new OutOfBoundsException("Agrument to density function of Zipf must be value in interval [1, " + this.populationSize + "], your value was " + d);
        }
        return 1.0 / ((double)n * this.harmonic);
    }

    public double mean() {
        return (double)this.populationSize / this.harmonic;
    }

    public double variance() {
        return (((double)this.populationSize + 1.0) / 2.0 - (double)this.populationSize / this.harmonic) * ((double)this.populationSize / this.harmonic);
    }
}

