/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.dag.api.TezException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Unstable
@InterfaceAudience.Private
public class JavaOptsChecker {
    private static final Logger LOG = LoggerFactory.getLogger(JavaOptsChecker.class);
    private static final Pattern pattern = Pattern.compile("\\s*(-XX:([\\+|\\-]?)(\\S+))\\s*");

    public void checkOpts(String opts) throws TezException {
        TreeSet<String> gcOpts = new TreeSet<String>();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking JVM GC opts: " + opts);
        }
        Matcher matcher = pattern.matcher(opts);
        while (matcher.find()) {
            int val;
            String opt;
            if (matcher.groupCount() != 3 || !(opt = matcher.group(3)).matches("Use.+GC")) continue;
            int n = val = matcher.group(2).equals("+") ? 1 : -1;
            if (gcOpts.contains(opt)) {
                ++val;
            }
            if (val > 0) {
                gcOpts.add(opt);
                continue;
            }
            gcOpts.remove(opt);
        }
        if (gcOpts.size() > 1) {
            if (gcOpts.size() == 2 && gcOpts.contains("UseParNewGC") && gcOpts.contains("UseConcMarkSweepGC")) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found clashing GC opts, conflicting GC Values=" + gcOpts);
            }
            throw new TezException("Invalid/conflicting GC options found, cmdOpts=\"" + opts + "\"");
        }
    }
}

