/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.impl;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.StringInterner;
import org.apache.tez.dag.records.TezTaskAttemptID;

public class EventMetaData
implements Writable {
    private EventProducerConsumerType producerConsumerType;
    private String taskVertexName;
    private String edgeVertexName;
    private TezTaskAttemptID taskAttemptID;

    public EventMetaData() {
    }

    public EventMetaData(EventProducerConsumerType generator, String taskVertexName, @Nullable String edgeVertexName, @Nullable TezTaskAttemptID taskAttemptID) {
        Preconditions.checkNotNull((Object)((Object)generator), (Object)"generator is null");
        Preconditions.checkNotNull((Object)taskVertexName, (Object)"taskVertexName is null");
        this.producerConsumerType = generator;
        this.taskVertexName = StringInterner.weakIntern((String)taskVertexName);
        this.edgeVertexName = StringInterner.weakIntern((String)edgeVertexName);
        this.taskAttemptID = taskAttemptID;
    }

    public EventProducerConsumerType getEventGenerator() {
        return this.producerConsumerType;
    }

    public TezTaskAttemptID getTaskAttemptID() {
        return this.taskAttemptID;
    }

    public String getTaskVertexName() {
        return this.taskVertexName;
    }

    public String getEdgeVertexName() {
        return this.edgeVertexName;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.producerConsumerType.ordinal());
        if (this.taskVertexName != null) {
            out.writeBoolean(true);
            out.writeUTF(this.taskVertexName);
        } else {
            out.writeBoolean(false);
        }
        if (this.edgeVertexName != null) {
            out.writeBoolean(true);
            out.writeUTF(this.edgeVertexName);
        } else {
            out.writeBoolean(false);
        }
        if (this.taskAttemptID != null) {
            out.writeBoolean(true);
            this.taskAttemptID.write(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.producerConsumerType = EventProducerConsumerType.values()[in.readInt()];
        if (in.readBoolean()) {
            this.taskVertexName = StringInterner.weakIntern((String)in.readUTF());
        }
        if (in.readBoolean()) {
            this.edgeVertexName = StringInterner.weakIntern((String)in.readUTF());
        }
        if (in.readBoolean()) {
            this.taskAttemptID = TezTaskAttemptID.readTezTaskAttemptID((DataInput)in);
        }
    }

    public String toString() {
        return "{ producerConsumerType=" + (Object)((Object)this.producerConsumerType) + ", taskVertexName=" + this.taskVertexName + ", edgeVertexName=" + this.edgeVertexName + ", taskAttemptId=" + (this.taskAttemptID == null ? "null" : this.taskAttemptID) + " }";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.edgeVertexName == null ? 0 : this.edgeVertexName.hashCode());
        result = 31 * result + (this.producerConsumerType == null ? 0 : this.producerConsumerType.hashCode());
        result = 31 * result + (this.taskAttemptID == null ? 0 : this.taskAttemptID.hashCode());
        result = 31 * result + (this.taskVertexName == null ? 0 : this.taskVertexName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventMetaData other = (EventMetaData)obj;
        if (this.edgeVertexName == null ? other.edgeVertexName != null : !this.edgeVertexName.equals(other.edgeVertexName)) {
            return false;
        }
        if (this.producerConsumerType != other.producerConsumerType) {
            return false;
        }
        if (this.taskAttemptID == null ? other.taskAttemptID != null : !this.taskAttemptID.equals((Object)other.taskAttemptID)) {
            return false;
        }
        return !(this.taskVertexName == null ? other.taskVertexName != null : !this.taskVertexName.equals(other.taskVertexName));
    }

    public static enum EventProducerConsumerType {
        INPUT,
        PROCESSOR,
        OUTPUT,
        SYSTEM;

    }
}

