/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.snapshot;

import java.io.IOException;
import java.io.OutputStream;

public final class BinaryEncoder {
    private final OutputStream output;

    public BinaryEncoder(OutputStream output) {
        this.output = output;
    }

    public BinaryEncoder writeInt(int i) throws IOException {
        int val = i << 1 ^ i >> 31;
        if ((val & 0xFFFFFF80) != 0) {
            this.output.write(0x80 | val & 0x7F);
            val >>>= 7;
            while (val > 127) {
                this.output.write(0x80 | val & 0x7F);
                val >>>= 7;
            }
        }
        this.output.write(val);
        return this;
    }

    public BinaryEncoder writeLong(long l) throws IOException {
        long val = l << 1 ^ l >> 63;
        if ((val & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.output.write((int)(0x80L | val & 0x7FL));
            val >>>= 7;
            while (val > 127L) {
                this.output.write((int)(0x80L | val & 0x7FL));
                val >>>= 7;
            }
        }
        this.output.write((int)val);
        return this;
    }

    public BinaryEncoder writeBytes(byte[] bytes) throws IOException {
        this.writeLong(bytes.length);
        this.output.write(bytes, 0, bytes.length);
        return this;
    }
}

