/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.hbase.txprune;

import com.google.common.util.concurrent.AbstractIdleService;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.tephra.hbase.txprune.DataJanitorState;

public class PruneUpperBoundWriter
extends AbstractIdleService {
    private static final Log LOG = LogFactory.getLog(PruneUpperBoundWriter.class);
    private final TableName tableName;
    private final DataJanitorState dataJanitorState;
    private final long pruneFlushInterval;
    private final ConcurrentSkipListMap<byte[], Long> pruneEntries;
    private final ConcurrentSkipListMap<byte[], Long> emptyRegions;
    private volatile Thread flushThread;
    private volatile boolean stopped;
    private long lastChecked;

    public PruneUpperBoundWriter(TableName tableName, DataJanitorState dataJanitorState, long pruneFlushInterval) {
        this.tableName = tableName;
        this.dataJanitorState = dataJanitorState;
        this.pruneFlushInterval = pruneFlushInterval;
        this.pruneEntries = new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR);
        this.emptyRegions = new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR);
    }

    public void persistPruneEntry(byte[] regionName, long pruneUpperBound) {
        this.warnIfNotRunning(regionName);
        this.pruneEntries.put(regionName, pruneUpperBound);
    }

    public void persistRegionEmpty(byte[] regionName, long time) {
        this.warnIfNotRunning(regionName);
        this.emptyRegions.put(regionName, time);
    }

    public boolean isAlive() {
        return this.flushThread != null && this.flushThread.isAlive();
    }

    protected void startUp() throws Exception {
        LOG.info((Object)"Starting PruneUpperBoundWriter Thread.");
        this.startFlushThread();
    }

    protected void shutDown() throws Exception {
        LOG.info((Object)"Stopping PruneUpperBoundWriter Thread.");
        this.stopped = true;
        if (this.flushThread != null) {
            this.flushThread.interrupt();
            this.flushThread.join(TimeUnit.SECONDS.toMillis(1L));
            if (this.flushThread.isAlive()) {
                this.flushThread.interrupt();
                this.flushThread.join(TimeUnit.SECONDS.toMillis(1L));
            }
        }
    }

    private void startFlushThread() {
        this.flushThread = new Thread("tephra-prune-upper-bound-writer"){

            @Override
            public void run() {
                while (!this.isInterrupted() && !PruneUpperBoundWriter.this.stopped) {
                    long now = System.currentTimeMillis();
                    if (now > PruneUpperBoundWriter.this.lastChecked + PruneUpperBoundWriter.this.pruneFlushInterval) {
                        try {
                            User.runAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                                @Override
                                public Void run() throws Exception {
                                    Map.Entry firstEntry;
                                    while (!PruneUpperBoundWriter.this.pruneEntries.isEmpty()) {
                                        firstEntry = PruneUpperBoundWriter.this.pruneEntries.firstEntry();
                                        PruneUpperBoundWriter.this.dataJanitorState.savePruneUpperBoundForRegion((byte[])firstEntry.getKey(), (Long)firstEntry.getValue());
                                        PruneUpperBoundWriter.this.pruneEntries.remove(firstEntry.getKey(), firstEntry.getValue());
                                    }
                                    while (!PruneUpperBoundWriter.this.emptyRegions.isEmpty()) {
                                        firstEntry = PruneUpperBoundWriter.this.emptyRegions.firstEntry();
                                        PruneUpperBoundWriter.this.dataJanitorState.saveEmptyRegionForTime((Long)firstEntry.getValue(), (byte[])firstEntry.getKey());
                                        PruneUpperBoundWriter.this.emptyRegions.remove(firstEntry.getKey(), firstEntry.getValue());
                                    }
                                    return null;
                                }
                            });
                        }
                        catch (IOException ex) {
                            LOG.warn((Object)("Cannot record prune upper bound for a region to table " + PruneUpperBoundWriter.this.tableName.getNameWithNamespaceInclAsString()), (Throwable)ex);
                        }
                        PruneUpperBoundWriter.this.lastChecked = now;
                    }
                    try {
                        TimeUnit.SECONDS.sleep(1L);
                    }
                    catch (InterruptedException ex) {
                        this.interrupt();
                        break;
                    }
                }
                LOG.info((Object)"PruneUpperBound Writer thread terminated.");
            }
        };
        this.flushThread.setDaemon(true);
        this.flushThread.start();
    }

    private void warnIfNotRunning(byte[] regionName) {
        if (!this.isRunning() || !this.isAlive()) {
            LOG.warn((Object)String.format("Trying to persist prune upper bound for region %s when writer is not %s!", Bytes.toStringBinary((byte[])regionName), this.isRunning() ? "alive" : "running"));
        }
    }
}

