/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.mapreduce.PhoenixTTLTool;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.mapreduce.util.DefaultMultiViewJobStatusTracker;
import org.apache.phoenix.mapreduce.util.MultiViewJobStatusTracker;
import org.apache.phoenix.mapreduce.util.ViewInfoTracker;
import org.apache.phoenix.mapreduce.util.ViewInfoWritable;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixTTLDeleteJobMapper
extends Mapper<NullWritable, ViewInfoTracker, NullWritable, NullWritable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixTTLDeleteJobMapper.class);
    private MultiViewJobStatusTracker multiViewJobStatusTracker;
    private static final int DEFAULT_MAX_RETRIES = 3;
    private static final int DEFAULT_RETRY_SLEEP_TIME_IN_MS = 10000;

    private void initMultiViewJobStatusTracker(Configuration config) throws Exception {
        try {
            Class defaultViewDeletionTrackerClass = DefaultMultiViewJobStatusTracker.class;
            if (config.get("phoenix.mapreduce.multi.mapper.tracker.path") != null) {
                LOGGER.info("Using customized tracker class : " + config.get("phoenix.mapreduce.multi.mapper.tracker.path"));
                defaultViewDeletionTrackerClass = Class.forName(config.get("phoenix.mapreduce.multi.mapper.tracker.path"));
            } else {
                LOGGER.info("Using default tracker class ");
            }
            this.multiViewJobStatusTracker = (MultiViewJobStatusTracker)defaultViewDeletionTrackerClass.newInstance();
        }
        catch (Exception e) {
            LOGGER.error("Getting exception While initializing initMultiViewJobStatusTracker with error message " + e.getMessage());
            throw e;
        }
    }

    protected void map(NullWritable key, ViewInfoTracker value, Mapper.Context context) throws IOException {
        try {
            Configuration config = context.getConfiguration();
            if (this.multiViewJobStatusTracker == null) {
                this.initMultiViewJobStatusTracker(config);
            }
            LOGGER.debug(String.format("Deleting from view %s, TenantID %s, and TTL value: %d", value.getViewName(), value.getTenantId(), value.getPhoenixTtl()));
            this.deleteExpiredRows(value, config, context);
        }
        catch (SQLException e) {
            LOGGER.error("Mapper got an exception while deleting expired rows : " + e.getMessage());
            throw new IOException(e.getMessage(), e.getCause());
        }
        catch (Exception e) {
            LOGGER.error("Getting IOException while running View TTL Deletion Job mapper with error : " + e.getMessage());
            throw new IOException(e.getMessage(), e.getCause());
        }
    }

    private void deleteExpiredRows(ViewInfoTracker value, Configuration config, Mapper.Context context) throws Exception {
        block25: {
            try (PhoenixConnection connection = (PhoenixConnection)ConnectionUtil.getInputConnection(config);){
                if (value.getTenantId() != null && !value.getTenantId().equals("NULL")) {
                    Properties props = new Properties();
                    props.setProperty("TenantId", value.getTenantId());
                    try (PhoenixConnection tenantConnection = (PhoenixConnection)DriverManager.getConnection(connection.getURL(), props);){
                        this.deleteExpiredRows(tenantConnection, value, config, context);
                        break block25;
                    }
                }
                this.deleteExpiredRows(connection, value, config, context);
            }
        }
    }

    private void deleteExpiredRows(PhoenixConnection connection, ViewInfoTracker viewInfoTracker, Configuration config, Mapper.Context context) throws Exception {
        try (PhoenixStatement pstmt = new PhoenixStatement(connection).unwrap(PhoenixStatement.class);){
            PTable pTable = PhoenixRuntime.getTable(connection, viewInfoTracker.getViewName());
            String deleteIfExpiredStatement = "SELECT /*+ NO_INDEX */ count(*) FROM " + viewInfoTracker.getViewName();
            if (viewInfoTracker.isIndexRelation()) {
                pTable = PhoenixRuntime.getTable(connection, viewInfoTracker.getRelationName());
                deleteIfExpiredStatement = "SELECT count(*) FROM " + viewInfoTracker.getRelationName();
            }
            String sourceTableName = pTable.getTableName().getString();
            this.multiViewJobStatusTracker.updateJobStatus(viewInfoTracker, 0L, ViewInfoWritable.ViewInfoJobState.INITIALIZED.getValue(), config, 0L, context.getJobName());
            QueryPlan queryPlan = pstmt.optimizeQuery(deleteIfExpiredStatement);
            Scan scan = queryPlan.getContext().getScan();
            byte[] emptyColumnFamilyName = SchemaUtil.getEmptyColumnFamily(pTable);
            byte[] emptyColumnName = pTable.getEncodingScheme() == PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS ? QueryConstants.EMPTY_COLUMN_BYTES : pTable.getEncodingScheme().encode(QueryConstants.ENCODED_EMPTY_COLUMN_NAME);
            scan.setAttribute("_EmptyCFName", emptyColumnFamilyName);
            scan.setAttribute("_EmptyCQName", emptyColumnName);
            scan.setAttribute("_DELETE_TTL_EXPIRED", PDataType.TRUE_BYTES);
            scan.setAttribute("_PhoenixTTL", Bytes.toBytes((long)viewInfoTracker.getPhoenixTtl()));
            scan.setAttribute("_PhoenixTTLScanTableName", Bytes.toBytes((String)sourceTableName));
            this.multiViewJobStatusTracker.updateJobStatus(viewInfoTracker, 0L, ViewInfoWritable.ViewInfoJobState.RUNNING.getValue(), config, 0L, context.getJobName());
            this.addingDeletionMarkWithRetries(pstmt, viewInfoTracker, config, context, queryPlan);
        }
        catch (Exception e) {
            if (e instanceof SQLException && ((SQLException)e).getErrorCode() == SQLExceptionCode.TABLE_UNDEFINED.getErrorCode()) {
                this.multiViewJobStatusTracker.updateJobStatus(viewInfoTracker, 0L, ViewInfoWritable.ViewInfoJobState.DELETED.getValue(), config, 0L, context.getJobName());
            }
            LOGGER.error(String.format("Had an issue to process the view: %s, see error %s ", viewInfoTracker.toString(), e.getMessage()));
        }
    }

    private boolean addingDeletionMarkWithRetries(PhoenixStatement stmt, ViewInfoTracker viewInfoTracker, Configuration config, Mapper.Context context, QueryPlan queryPlan) throws Exception {
        String viewInfo;
        int retry = 0;
        long startTime = System.currentTimeMillis();
        String string = viewInfo = viewInfoTracker.getTenantId() == null ? viewInfoTracker.getViewName() : viewInfoTracker.getTenantId() + "." + viewInfoTracker.getViewName();
        while (retry < 3) {
            try {
                PhoenixResultSet rs = stmt.newResultSet(queryPlan.iterator(), queryPlan.getProjector(), queryPlan.getContext());
                long numberOfDeletedRows = 0L;
                if (rs.next()) {
                    numberOfDeletedRows = rs.getLong(1);
                }
                this.multiViewJobStatusTracker.updateJobStatus(viewInfoTracker, numberOfDeletedRows, ViewInfoWritable.ViewInfoJobState.SUCCEEDED.getValue(), config, System.currentTimeMillis() - startTime, context.getJobName());
                PhoenixTTLTool.MR_COUNTER_METRICS metricsStatus = viewInfoTracker.isIndexRelation() ? PhoenixTTLTool.MR_COUNTER_METRICS.VIEW_INDEX_SUCCEED : PhoenixTTLTool.MR_COUNTER_METRICS.VIEW_SUCCEED;
                context.getCounter((Enum)metricsStatus).increment(1L);
                return true;
            }
            catch (Exception e) {
                PhoenixTTLTool.MR_COUNTER_METRICS metricsStatus;
                PhoenixTTLTool.MR_COUNTER_METRICS mR_COUNTER_METRICS = metricsStatus = viewInfoTracker.isIndexRelation() ? PhoenixTTLTool.MR_COUNTER_METRICS.VIEW_INDEX_FAILED : PhoenixTTLTool.MR_COUNTER_METRICS.VIEW_FAILED;
                if (e instanceof SQLException && ((SQLException)e).getErrorCode() == SQLExceptionCode.TABLE_UNDEFINED.getErrorCode()) {
                    LOGGER.info(viewInfo + " has been deleted : " + e.getMessage());
                    this.multiViewJobStatusTracker.updateJobStatus(viewInfoTracker, 0L, ViewInfoWritable.ViewInfoJobState.DELETED.getValue(), config, 0L, context.getJobName());
                    context.getCounter((Enum)metricsStatus).increment(1L);
                    return false;
                }
                if (++retry == 3) {
                    LOGGER.error("Deleting " + viewInfo + " expired rows has an exception for : " + e.getMessage());
                    this.multiViewJobStatusTracker.updateJobStatus(viewInfoTracker, 0L, ViewInfoWritable.ViewInfoJobState.FAILED.getValue(), config, 0L, context.getJobName());
                    context.getCounter((Enum)metricsStatus).increment(1L);
                    throw e;
                }
                Thread.sleep(10000L);
            }
        }
        return false;
    }
}

