/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.exception;

import java.sql.SQLSyntaxErrorException;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.MissingTokenException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.UnwantedTokenException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.exception.UnknownFunctionException;

public class PhoenixParserException
extends SQLSyntaxErrorException {
    private static final long serialVersionUID = 1L;

    public static final PhoenixParserException newException(Throwable cause, String[] tokens) {
        return new PhoenixParserException(PhoenixParserException.getErrorMessage(cause, tokens), cause);
    }

    public PhoenixParserException(String msg, Throwable throwable) {
        super(new SQLExceptionInfo.Builder(PhoenixParserException.getErrorCode(throwable)).setRootCause(throwable).setMessage(msg).build().toString(), PhoenixParserException.getErrorCode(throwable).getSQLState(), PhoenixParserException.getErrorCode(throwable).getErrorCode(), throwable);
    }

    public static String getLine(RecognitionException e) {
        return Integer.toString(e.token.getLine());
    }

    public static String getColumn(RecognitionException e) {
        return Integer.toString(e.token.getCharPositionInLine() + 1);
    }

    public static String getTokenLocation(RecognitionException e) {
        return "line " + PhoenixParserException.getLine(e) + ", column " + PhoenixParserException.getColumn(e) + ".";
    }

    public static String getErrorMessage(Throwable e, String[] tokenNames) {
        String msg;
        if (e instanceof MissingTokenException) {
            MissingTokenException mte = (MissingTokenException)e;
            String tokenName = mte.expecting == -1 ? "EOF" : tokenNames[mte.expecting];
            msg = "Missing \"" + tokenName + "\" at " + PhoenixParserException.getTokenLocation(mte);
        } else if (e instanceof UnwantedTokenException) {
            UnwantedTokenException ute = (UnwantedTokenException)e;
            String tokenName = ute.expecting == -1 ? "EOF" : tokenNames[ute.expecting];
            msg = "Unexpected input. Expecting \"" + tokenName + "\", got \"" + ute.getUnexpectedToken().getText() + "\" at " + PhoenixParserException.getTokenLocation(ute);
        } else if (e instanceof MismatchedTokenException) {
            MismatchedTokenException mte = (MismatchedTokenException)e;
            String tokenName = mte.expecting == -1 ? "EOF" : tokenNames[mte.expecting];
            msg = "Mismatched input. Expecting \"" + tokenName + "\", got \"" + mte.token.getText() + "\" at " + PhoenixParserException.getTokenLocation(mte);
        } else if (e instanceof RecognitionException) {
            RecognitionException re = (RecognitionException)e;
            msg = "Encountered \"" + re.token.getText() + "\" at " + PhoenixParserException.getTokenLocation(re);
        } else if (e instanceof UnknownFunctionException) {
            UnknownFunctionException ufe = (UnknownFunctionException)e;
            msg = "Unknown function: \"" + ufe.getFuncName() + "\".";
        } else {
            msg = e.getMessage();
        }
        return msg;
    }

    public static SQLExceptionCode getErrorCode(Throwable e) {
        if (e instanceof MissingTokenException) {
            return SQLExceptionCode.MISSING_TOKEN;
        }
        if (e instanceof UnwantedTokenException) {
            return SQLExceptionCode.UNWANTED_TOKEN;
        }
        if (e instanceof MismatchedTokenException) {
            return SQLExceptionCode.MISMATCHED_TOKEN;
        }
        if (e instanceof UnknownFunctionException) {
            return SQLExceptionCode.UNKNOWN_FUNCTION;
        }
        return SQLExceptionCode.PARSER_ERROR;
    }
}

