/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import java.util.Objects;
import org.apache.phoenix.parse.BindParseNode;
import org.apache.phoenix.parse.ComparisonParseNode;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.ParseNode;

public class OffsetNode {
    private final ParseNode node;

    OffsetNode(ParseNode node) throws SQLException {
        if (!(node instanceof BindParseNode || node instanceof LiteralParseNode || node instanceof ComparisonParseNode)) {
            throw new SQLException("Bad Expression Passed To Offset, node of type" + node.getClass().getName());
        }
        this.node = node;
    }

    public ParseNode getOffsetParseNode() {
        return this.node;
    }

    public boolean isIntegerOffset() {
        return this.node instanceof BindParseNode || this.node instanceof LiteralParseNode;
    }

    public String toString() {
        return this.node.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OffsetNode that = (OffsetNode)o;
        return Objects.equals(this.node, that.node);
    }

    public int hashCode() {
        return Objects.hash(this.node);
    }
}

