/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.tenant;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OMMultiTenantManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.S3SecretManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.OmDBAccessIdInfo;
import org.apache.hadoop.ozone.om.helpers.OmDBUserPrincipalInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.tenant.OMTenantRevokeUserAccessIdResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.DisallowedUntilLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeature;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMTenantRevokeUserAccessIdRequest
extends OMClientRequest {
    public static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMTenantRevokeUserAccessIdRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMTenantRevokeUserAccessIdRequest.class);
    }

    public OMTenantRevokeUserAccessIdRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    @DisallowedUntilLayoutVersion(value=OMLayoutFeature.MULTITENANCY_SCHEMA)
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2);
        OMLayoutFeatureAspect.aspectOf().checkLayoutFeature(joinPoint);
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(joinPoint);
        }
        OzoneManagerProtocolProtos.OMRequest omRequest = super.preExecute(ozoneManager);
        OzoneManagerProtocolProtos.TenantRevokeUserAccessIdRequest request = omRequest.getTenantRevokeUserAccessIdRequest();
        String accessId = request.getAccessId();
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        OmDBAccessIdInfo accessIdInfo = (OmDBAccessIdInfo)omMetadataManager.getTenantAccessIdTable().get((Object)accessId);
        OMMultiTenantManager multiTenantManager = ozoneManager.getMultiTenantManager();
        if (accessIdInfo == null) {
            throw new OMException("accessId '" + accessId + "' doesn't exist", OMException.ResultCodes.ACCESS_ID_NOT_FOUND);
        }
        String tenantId = request.getTenantId();
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            Optional<String> optionalTenantId = multiTenantManager.getTenantForAccessID(accessId);
            if (!optionalTenantId.isPresent()) {
                throw new OMException("accessId '" + accessId + "' is not assigned to " + "any tenant", OMException.ResultCodes.TENANT_NOT_FOUND);
            }
            tenantId = optionalTenantId.get();
            assert (!StringUtils.isEmpty((CharSequence)tenantId));
        }
        multiTenantManager.checkTenantExistence(tenantId);
        multiTenantManager.checkTenantAdmin(tenantId, false);
        if (accessIdInfo.getIsAdmin()) {
            throw new OMException("accessId '" + accessId + "' is a tenant admin of " + "tenant'" + tenantId + "'. Please revoke its tenant admin " + "privilege before revoking the accessId.", OMException.ResultCodes.PERMISSION_DENIED);
        }
        multiTenantManager.getAuthorizerLock().tryWriteLockInOMRequest();
        try {
            multiTenantManager.getAuthorizerOp().revokeUserAccessId(accessId, tenantId);
        }
        catch (Exception e) {
            multiTenantManager.getAuthorizerLock().unlockWriteInOMRequest();
            throw e;
        }
        OzoneManagerProtocolProtos.OMRequest.Builder omRequestBuilder = omRequest.toBuilder().setTenantRevokeUserAccessIdRequest(OzoneManagerProtocolProtos.TenantRevokeUserAccessIdRequest.newBuilder().setAccessId(accessId).setTenantId(tenantId).build());
        return omRequestBuilder.build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        String userPrincipal;
        Exception exception;
        String tenantId;
        String accessId;
        HashMap<String, String> auditMap;
        OMTenantRevokeUserAccessIdResponse omClientResponse;
        OMMetrics omMetrics;
        block13: {
            long transactionLogIndex = context.getIndex();
            OMMultiTenantManager multiTenantManager = ozoneManager.getMultiTenantManager();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumTenantRevokeUsers();
            omClientResponse = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            auditMap = new HashMap<String, String>();
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            OzoneManagerProtocolProtos.TenantRevokeUserAccessIdRequest request = this.getOmRequest().getTenantRevokeUserAccessIdRequest();
            accessId = request.getAccessId();
            tenantId = request.getTenantId();
            boolean acquiredVolumeLock = false;
            exception = null;
            userPrincipal = null;
            String volumeName = null;
            try {
                try {
                    volumeName = ozoneManager.getMultiTenantManager().getTenantVolumeName(tenantId);
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName}));
                    acquiredVolumeLock = this.getOmLockDetails().isLockAcquired();
                    OmDBAccessIdInfo omDBAccessIdInfo = (OmDBAccessIdInfo)omMetadataManager.getTenantAccessIdTable().get((Object)accessId);
                    Preconditions.checkNotNull((Object)omDBAccessIdInfo);
                    userPrincipal = omDBAccessIdInfo.getUserPrincipal();
                    Preconditions.checkNotNull((Object)userPrincipal);
                    OmDBUserPrincipalInfo principalInfo = (OmDBUserPrincipalInfo)omMetadataManager.getPrincipalToAccessIdsTable().getIfExist((Object)userPrincipal);
                    Preconditions.checkNotNull((Object)principalInfo);
                    principalInfo.removeAccessId(accessId);
                    CacheValue cacheValue = !principalInfo.getAccessIds().isEmpty() ? CacheValue.get((long)transactionLogIndex, (Object)principalInfo) : CacheValue.get((long)transactionLogIndex);
                    omMetadataManager.getPrincipalToAccessIdsTable().addCacheEntry(new CacheKey((Object)userPrincipal), cacheValue);
                    omMetadataManager.getTenantAccessIdTable().addCacheEntry(new CacheKey((Object)accessId), CacheValue.get((long)transactionLogIndex));
                    S3SecretManager s3SecretManager = ozoneManager.getS3SecretManager();
                    s3SecretManager.invalidateCacheEntry(accessId);
                    multiTenantManager.getCacheOp().revokeUserAccessId(accessId, tenantId);
                    omResponse.setTenantRevokeUserAccessIdResponse(OzoneManagerProtocolProtos.TenantRevokeUserAccessIdResponse.newBuilder().build());
                    omClientResponse = new OMTenantRevokeUserAccessIdResponse(omResponse.build(), accessId, userPrincipal, principalInfo, s3SecretManager);
                }
                catch (IOException | InvalidPathException ex) {
                    exception = ex;
                    omClientResponse = new OMTenantRevokeUserAccessIdResponse(this.createErrorOMResponse(omResponse, exception));
                    if (acquiredVolumeLock) {
                        Preconditions.checkNotNull((Object)volumeName);
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName}));
                    }
                    multiTenantManager.getAuthorizerLock().unlockWriteInOMRequest();
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                if (acquiredVolumeLock) {
                    Preconditions.checkNotNull((Object)volumeName);
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName}));
                }
                multiTenantManager.getAuthorizerLock().unlockWriteInOMRequest();
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (acquiredVolumeLock) {
                Preconditions.checkNotNull((Object)volumeName);
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName}));
            }
            multiTenantManager.getAuthorizerLock().unlockWriteInOMRequest();
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        auditMap.put("tenant", tenantId);
        auditMap.put("accessId", accessId);
        auditMap.put("userPrincipal", userPrincipal);
        this.markForAudit(ozoneManager.getAuditLogger(), this.buildAuditMessage(OMAction.TENANT_REVOKE_USER_ACCESSID, auditMap, exception, this.getOmRequest().getUserInfo()));
        if (exception == null) {
            LOG.info("Revoked user '{}' accessId '{}' to tenant '{}'", new Object[]{userPrincipal, accessId, tenantId});
        } else {
            LOG.error("Failed to revoke user '{}' accessId '{}' to tenant '{}': {}", new Object[]{userPrincipal, accessId, tenantId, exception.getMessage()});
            omMetrics.incNumTenantRevokeUserFails();
        }
        return omClientResponse;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMTenantRevokeUserAccessIdRequest.java", OMTenantRevokeUserAccessIdRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.s3.tenant.OMTenantRevokeUserAccessIdRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 79);
    }
}

