/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyDeleteRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyDeleteResponseWithFSO;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeyDeleteRequestWithFSO
extends OMKeyDeleteRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMKeyDeleteRequestWithFSO.class);

    public OMKeyDeleteRequestWithFSO(OzoneManagerProtocolProtos.OMRequest omRequest, BucketLayout bucketLayout) {
        super(omRequest, bucketLayout);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        OMClientRequest.Result result;
        OMClientResponse omClientResponse;
        Exception exception;
        OzoneManagerProtocolProtos.UserInfo userInfo;
        AuditLogger auditLogger;
        OMMetrics omMetrics;
        String keyName;
        String bucketName;
        String volumeName;
        Map<String, String> auditMap;
        OzoneManagerProtocolProtos.DeleteKeyRequest deleteKeyRequest;
        block23: {
            long trxnLogIndex = context.getIndex();
            deleteKeyRequest = this.getOmRequest().getDeleteKeyRequest();
            OzoneManagerProtocolProtos.KeyArgs keyArgs = deleteKeyRequest.getKeyArgs();
            auditMap = this.buildLightKeyArgsAuditMap(keyArgs);
            volumeName = keyArgs.getVolumeName();
            bucketName = keyArgs.getBucketName();
            keyName = keyArgs.getKeyName();
            boolean recursive = keyArgs.getRecursive();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumKeyDeletes();
            auditLogger = ozoneManager.getAuditLogger();
            userInfo = this.getOmRequest().getUserInfo();
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            exception = null;
            boolean acquiredLock = false;
            omClientResponse = null;
            result = null;
            OmBucketInfo omBucketInfo = null;
            try {
                try {
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    acquiredLock = this.getOmLockDetails().isLockAcquired();
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    OzoneFileStatus keyStatus = OMFileRequest.getOMKeyInfoIfExists(omMetadataManager, volumeName, bucketName, keyName, 0L, ozoneManager.getDefaultReplicationConfig());
                    if (keyStatus == null) {
                        throw new OMException("Key not found. Key:" + keyName, OMException.ResultCodes.KEY_NOT_FOUND);
                    }
                    OmKeyInfo omKeyInfo = keyStatus.getKeyInfo();
                    String fileName = OzoneFSUtils.getFileName((String)keyName);
                    omKeyInfo.setKeyName(fileName);
                    omKeyInfo.setUpdateID(trxnLogIndex);
                    long volumeId = omMetadataManager.getVolumeId(volumeName);
                    long bucketId = omMetadataManager.getBucketId(volumeName, bucketName);
                    String ozonePathKey = omMetadataManager.getOzonePathKey(volumeId, bucketId, omKeyInfo.getParentObjectID(), omKeyInfo.getFileName());
                    OmKeyInfo deletedOpenKeyInfo = null;
                    if (keyStatus.isDirectory()) {
                        if (!recursive && OMFileRequest.hasChildren(omKeyInfo, omMetadataManager)) {
                            throw new OMException("Directory is not empty. Key:" + keyName, OMException.ResultCodes.DIRECTORY_NOT_EMPTY);
                        }
                        omMetadataManager.getDirectoryTable().addCacheEntry(new CacheKey((Object)ozonePathKey), CacheValue.get((long)trxnLogIndex));
                    } else {
                        omMetadataManager.getKeyTable(this.getBucketLayout()).addCacheEntry(new CacheKey((Object)ozonePathKey), CacheValue.get((long)trxnLogIndex));
                    }
                    omBucketInfo = this.getBucketInfo(omMetadataManager, volumeName, bucketName);
                    long quotaReleased = OMKeyDeleteRequestWithFSO.sumBlockLengths(omKeyInfo);
                    omBucketInfo.incrUsedBytes(-quotaReleased);
                    omBucketInfo.incrUsedNamespace(-1L);
                    String dbOpenKey = null;
                    String hsyncClientId = (String)omKeyInfo.getMetadata().get("hsyncClientId");
                    if (hsyncClientId != null) {
                        long parentId;
                        Table openKeyTable = omMetadataManager.getOpenKeyTable(this.getBucketLayout());
                        OmKeyInfo openKeyInfo = (OmKeyInfo)openKeyTable.get((Object)(dbOpenKey = omMetadataManager.getOpenFileName(volumeId, bucketId, parentId = omKeyInfo.getParentObjectID(), fileName, hsyncClientId)));
                        if (openKeyInfo != null) {
                            openKeyInfo.getMetadata().put("deletedHsyncKey", "true");
                            openKeyTable.addCacheEntry((Object)dbOpenKey, (Object)openKeyInfo, trxnLogIndex);
                            deletedOpenKeyInfo = openKeyInfo;
                        } else {
                            LOG.warn("Potentially inconsistent DB state: open key not found with dbOpenKey '{}'", (Object)dbOpenKey);
                        }
                    }
                    if (keyStatus.isFile()) {
                        auditMap.put("dataSize", String.valueOf(omKeyInfo.getDataSize()));
                        auditMap.put("replicationConfig", omKeyInfo.getReplicationConfig().toString());
                    }
                    omClientResponse = new OMKeyDeleteResponseWithFSO(omResponse.setDeleteKeyResponse(OzoneManagerProtocolProtos.DeleteKeyResponse.newBuilder()).build(), keyName, omKeyInfo, omBucketInfo.copyObject(), keyStatus.isDirectory(), volumeId, deletedOpenKeyInfo);
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException | InvalidPathException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = new OMKeyDeleteResponseWithFSO(this.createErrorOMResponse(omResponse, exception), this.getBucketLayout());
                    if (acquiredLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                if (acquiredLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (acquiredLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        this.markForAudit(auditLogger, this.buildAuditMessage(OMAction.DELETE_KEY, auditMap, exception, userInfo));
        switch (result) {
            case SUCCESS: {
                omMetrics.decNumKeys();
                LOG.debug("Key deleted. Volume:{}, Bucket:{}, Key:{}", new Object[]{volumeName, bucketName, keyName});
                break;
            }
            case FAILURE: {
                omMetrics.incNumKeyDeleteFails();
                LOG.error("Key delete failed. Volume:{}, Bucket:{}, Key:{}.", new Object[]{volumeName, bucketName, keyName, exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMKeyDeleteRequest: {}", (Object)deleteKeyRequest);
            }
        }
        return omClientResponse;
    }

    @Override
    protected OzoneManagerProtocolProtos.KeyArgs resolveBucketAndCheckAcls(OzoneManager ozoneManager, OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs) throws IOException {
        return this.resolveBucketAndCheckKeyAclsWithFSO(newKeyArgs.build(), ozoneManager, IAccessAuthorizer.ACLType.DELETE);
    }
}

