/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.zip.Checksum;
import org.apache.hadoop.hdds.JavaUtils;
import org.apache.hadoop.ozone.common.ChecksumByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChecksumByteBufferImpl
implements ChecksumByteBuffer {
    private static final Logger LOG = LoggerFactory.getLogger(ChecksumByteBufferImpl.class);
    private final Checksum checksum;
    private static final Field IS_READY_ONLY_FIELD;
    private static final MethodHandle BYTE_BUFFER_UPDATE;

    public ChecksumByteBufferImpl(Checksum impl) {
        this.checksum = impl;
    }

    @Override
    public void update(ByteBuffer buffer) {
        if (BYTE_BUFFER_UPDATE != null) {
            try {
                BYTE_BUFFER_UPDATE.invokeExact(this.checksum, buffer);
                return;
            }
            catch (Throwable e) {
                throw new IllegalStateException("Error invoking " + BYTE_BUFFER_UPDATE, e);
            }
        }
        if (IS_READY_ONLY_FIELD != null) {
            try {
                IS_READY_ONLY_FIELD.setBoolean(buffer, false);
            }
            catch (IllegalAccessException e) {
                LOG.error("Cannot access isReadOnly in ByteBuffer", (Throwable)e);
            }
        }
        if (buffer.hasArray()) {
            this.checksum.update(buffer.array(), buffer.position() + buffer.arrayOffset(), buffer.remaining());
        } else {
            byte[] b = new byte[buffer.remaining()];
            buffer.get(b);
            this.checksum.update(b, 0, b.length);
        }
    }

    @Override
    public void update(byte[] b, int off, int len) {
        this.checksum.update(b, off, len);
    }

    @Override
    public void update(int i) {
        this.checksum.update(i);
    }

    @Override
    public long getValue() {
        return this.checksum.getValue();
    }

    @Override
    public void reset() {
        this.checksum.reset();
    }

    static {
        Field f = null;
        if (JavaUtils.isJavaVersionAtMost(8)) {
            try {
                f = ByteBuffer.class.getDeclaredField("isReadOnly");
                f.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                LOG.error("No isReadOnly field in ByteBuffer", (Throwable)e);
            }
        }
        IS_READY_ONLY_FIELD = f;
        MethodHandle byteBufferUpdate = null;
        if (JavaUtils.isJavaVersionAtLeast(9)) {
            try {
                byteBufferUpdate = MethodHandles.publicLookup().findVirtual(Checksum.class, "update", MethodType.methodType(Void.TYPE, ByteBuffer.class));
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed to lookup Checksum.update(ByteBuffer).");
            }
        }
        BYTE_BUFFER_UPDATE = byteBufferUpdate;
    }
}

