/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.ScmBlockLocationProtocolProtos;

public final class BlockGroup {
    private String groupID;
    private List<BlockID> blockIDs;

    private BlockGroup(String groupID, List<BlockID> blockIDs) {
        this.groupID = groupID;
        this.blockIDs = blockIDs;
    }

    public List<BlockID> getBlockIDList() {
        return this.blockIDs;
    }

    public String getGroupID() {
        return this.groupID;
    }

    public ScmBlockLocationProtocolProtos.KeyBlocks getProto() {
        ScmBlockLocationProtocolProtos.KeyBlocks.Builder kbb = ScmBlockLocationProtocolProtos.KeyBlocks.newBuilder();
        for (BlockID block : this.blockIDs) {
            kbb.addBlocks(block.getProtobuf());
        }
        return kbb.setKey(this.groupID).build();
    }

    public static BlockGroup getFromProto(ScmBlockLocationProtocolProtos.KeyBlocks proto) {
        ArrayList<BlockID> blockIDs = new ArrayList<BlockID>();
        for (HddsProtos.BlockID block : proto.getBlocksList()) {
            blockIDs.add(new BlockID(block.getContainerBlockID().getContainerID(), block.getContainerBlockID().getLocalID()));
        }
        return BlockGroup.newBuilder().setKeyName(proto.getKey()).addAllBlockIDs(blockIDs).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "BlockGroup[groupID='" + this.groupID + '\'' + ", blockIDs=" + this.blockIDs + ']';
    }

    public static class Builder {
        private String groupID;
        private List<BlockID> blockIDs;

        public Builder setKeyName(String blockGroupID) {
            this.groupID = blockGroupID;
            return this;
        }

        public Builder addAllBlockIDs(List<BlockID> keyBlocks) {
            this.blockIDs = keyBlocks;
            return this;
        }

        public BlockGroup build() {
            return new BlockGroup(this.groupID, this.blockIDs);
        }
    }
}

