/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.certificate.client;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.SCMSecurityProtocolProtos;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CAType;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateApprover;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateServer;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateStore;
import org.apache.hadoop.hdds.security.x509.certificate.authority.DefaultCAServer;
import org.apache.hadoop.hdds.security.x509.certificate.authority.profile.DefaultCAProfile;
import org.apache.hadoop.hdds.security.x509.certificate.authority.profile.PKIProfile;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.security.x509.certificate.client.DefaultCertificateClient;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateCodec;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateSignRequest;
import org.apache.hadoop.ozone.OzoneConsts;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMCertificateClient
extends DefaultCertificateClient {
    private static final Logger LOG = LoggerFactory.getLogger(SCMCertificateClient.class);
    public static final String COMPONENT_NAME = Paths.get("scm", "sub-ca").toString();
    private String scmId;
    private String cId;
    private String scmHostname;
    private ExecutorService executorService;
    private boolean isPrimarySCM = false;
    private Consumer<String> saveCertIdCallback;

    public SCMCertificateClient(SecurityConfig securityConfig, SCMSecurityProtocolClientSideTranslatorPB scmClient, String scmId, String clusterId, String scmCertId, String hostname, boolean isPrimarySCM, Consumer<String> saveCertId) {
        super(securityConfig, scmClient, LOG, scmCertId, COMPONENT_NAME, HddsUtils.threadNamePrefix((Object)scmId), saveCertId, null);
        this.scmId = scmId;
        this.cId = clusterId;
        this.scmHostname = hostname;
        this.isPrimarySCM = isPrimarySCM;
        this.saveCertIdCallback = saveCertId;
    }

    public SCMCertificateClient(SecurityConfig securityConfig, SCMSecurityProtocolClientSideTranslatorPB scmClient, String scmId, String clusterId, String scmCertId, String hostname) {
        this(securityConfig, scmClient, scmId, clusterId, scmCertId, hostname, COMPONENT_NAME);
    }

    private SCMCertificateClient(SecurityConfig securityConfig, SCMSecurityProtocolClientSideTranslatorPB scmClient, String scmId, String clusterId, String scmCertId, String hostname, String component) {
        super(securityConfig, scmClient, LOG, scmCertId, component, HddsUtils.threadNamePrefix((Object)scmId), null, null);
        this.scmId = scmId;
        this.cId = clusterId;
        this.scmHostname = hostname;
    }

    public SCMCertificateClient(SecurityConfig securityConfig, SCMSecurityProtocolClientSideTranslatorPB scmClient, String certSerialId) {
        this(securityConfig, scmClient, null, null, certSerialId, null, COMPONENT_NAME);
    }

    public SCMCertificateClient(SecurityConfig securityConfig, SCMSecurityProtocolClientSideTranslatorPB scmClient, String certSerialId, String scmId, String component) {
        this(securityConfig, scmClient, scmId, null, certSerialId, null, component);
    }

    @Override
    public CertificateSignRequest.Builder configureCSRBuilder() throws SCMSecurityException {
        String subject = "scm-sub@" + this.scmHostname;
        LOG.info("Creating csr for SCM->hostName:{},scmId:{},clusterId:{},subject:{}", new Object[]{this.scmHostname, this.scmId, this.cId, subject});
        return super.configureCSRBuilder().setSubject(subject).setScmID(this.scmId).setClusterID(this.cId).setCA(Boolean.valueOf(true)).setKey(new KeyPair(this.getPublicKey(), this.getPrivateKey()));
    }

    @Override
    protected boolean shouldStartCertificateRenewerService() {
        return false;
    }

    @Override
    public Logger getLogger() {
        return LOG;
    }

    @Override
    protected SCMSecurityProtocolProtos.SCMGetCertResponseProto sign(CertificateSignRequest request) {
        throw new UnsupportedOperationException("Invalid call to SCMCertificateClient#sign(CertificateSignRequest. SCM certificate client uses a different mechanism to sign the SCMs' certificate.");
    }

    @Override
    public String signAndStoreCertificate(CertificateSignRequest csr, Path certPath, boolean renew) {
        try {
            HddsProtos.ScmNodeDetailsProto scmNodeDetailsProto = HddsProtos.ScmNodeDetailsProto.newBuilder().setClusterId(this.cId).setHostName(this.scmHostname).setScmNodeId(this.scmId).build();
            SCMSecurityProtocolProtos.SCMGetCertResponseProto response = this.getScmSecureClient().getSCMCertChain(scmNodeDetailsProto, csr.toEncodedFormat(), true);
            CertificateCodec certCodec = new CertificateCodec(this.getSecurityConfig(), certPath);
            String pemEncodedCert = response.getX509Certificate();
            if (response.hasX509CACertificate()) {
                String pemEncodedRootCert = response.getX509CACertificate();
                this.storeCertificate(pemEncodedRootCert, CAType.SUBORDINATE, certCodec, false, !renew);
                this.storeCertificate(pemEncodedCert, CAType.NONE, certCodec, false, !renew);
                certCodec.writeCertificate(certCodec.getLocation().toAbsolutePath(), this.getSecurityConfig().getCertificateFileName(), pemEncodedCert);
                X509Certificate certificate = CertificateCodec.getX509Certificate((String)pemEncodedCert);
                return certificate.getSerialNumber().toString();
            }
            throw new RuntimeException("Unable to retrieve SCM certificate chain");
        }
        catch (Throwable e) {
            LOG.error("Error while fetching/storing SCM signed certificate.", e);
            throw new RuntimeException(e);
        }
    }

    public void refreshCACertificates() throws IOException {
        if (this.executorService == null) {
            this.executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(this.threadNamePrefix() + this.getComponentName() + "-refreshCACertificates").setDaemon(true).build());
        }
        this.executorService.execute(new RefreshCACertificates(this.getScmSecureClient()));
    }

    @Override
    public synchronized void close() throws IOException {
        super.close();
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    @Override
    protected void recoverStateIfNeeded(CertificateClient.InitResponse state) throws IOException {
        LOG.info("Init response: {}", (Object)state);
        switch (state) {
            case SUCCESS: {
                LOG.info("Initialization successful.");
                break;
            }
            case GETCERT: {
                if (!this.isPrimarySCM) {
                    this.getRootCASignedSCMCert();
                } else {
                    this.getPrimarySCMSelfSignedCert();
                }
                LOG.info("Successfully stored SCM signed certificate.");
                break;
            }
            default: {
                LOG.error("SCM security initialization failed. Init response: {}", (Object)state);
                throw new RuntimeException("SCM security initialization failed.");
            }
        }
    }

    private void getRootCASignedSCMCert() {
        try {
            CertificateSignRequest csr = this.configureCSRBuilder().build();
            HddsProtos.ScmNodeDetailsProto scmNodeDetailsProto = HddsProtos.ScmNodeDetailsProto.newBuilder().setClusterId(this.cId).setHostName(this.scmHostname).setScmNodeId(this.scmId).build();
            SCMSecurityProtocolProtos.SCMGetCertResponseProto response = this.getScmSecureClient().getSCMCertChain(scmNodeDetailsProto, csr.toEncodedFormat(), false);
            String pemEncodedCert = response.getX509Certificate();
            if (!response.hasX509CACertificate()) {
                throw new RuntimeException("Unable to retrieve SCM certificate chain");
            }
            String pemEncodedRootCert = response.getX509CACertificate();
            this.storeCertificate(pemEncodedRootCert, CAType.SUBORDINATE);
            this.storeCertificate(pemEncodedCert, CAType.NONE);
            this.persistSubCACertificate(pemEncodedCert);
            X509Certificate certificate = CertificateCodec.getX509Certificate((String)pemEncodedCert);
            this.saveCertIdCallback.accept(certificate.getSerialNumber().toString());
        }
        catch (IOException | CertificateException e) {
            LOG.error("Error while fetching/storing SCM signed certificate.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void getPrimarySCMSelfSignedCert() {
        try {
            CertificateServer rootCAServer = this.initializeRootCertificateServer(this.getSecurityConfig(), null, BigInteger.ONE, new DefaultCAProfile(), OzoneConsts.SCM_ROOT_CA_COMPONENT_NAME);
            CertPath rootCACertificatePath = rootCAServer.getCaCertPath();
            String pemEncodedRootCert = CertificateCodec.getPEMEncodedString((CertPath)rootCACertificatePath);
            CertificateSignRequest csr = this.configureCSRBuilder().build();
            String subCaSerialId = BigInteger.ONE.add(BigInteger.ONE).toString();
            CertPath scmSubCACertPath = rootCAServer.requestCertificate(csr.generateCSR(), CertificateApprover.ApprovalType.KERBEROS_TRUSTED, HddsProtos.NodeType.SCM, subCaSerialId).get();
            String pemEncodedCert = CertificateCodec.getPEMEncodedString((CertPath)scmSubCACertPath);
            this.storeCertificate(pemEncodedRootCert, CAType.SUBORDINATE);
            this.storeCertificate(pemEncodedCert, CAType.NONE);
            this.persistSubCACertificate(pemEncodedCert);
            X509Certificate cert = (X509Certificate)scmSubCACertPath.getCertificates().get(0);
            this.saveCertIdCallback.accept(cert.getSerialNumber().toString());
        }
        catch (IOException | InterruptedException | CertificateException | ExecutionException e) {
            LOG.error("Error while fetching/storing SCM signed certificate.", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public CertificateServer initializeRootCertificateServer(SecurityConfig config, CertificateStore scmCertStore, BigInteger rootCertId, PKIProfile pkiProfile, String component) throws IOException {
        String subject = String.format("scm@", rootCertId) + InetAddress.getLocalHost().getHostName();
        DefaultCAServer rootCAServer = new DefaultCAServer(subject, this.cId, this.scmId, scmCertStore, rootCertId, pkiProfile, component);
        rootCAServer.init(config, CAType.ROOT);
        return rootCAServer;
    }

    private void persistSubCACertificate(String certificateHolder) throws IOException {
        CertificateCodec certCodec = new CertificateCodec(this.getSecurityConfig(), this.getComponentName());
        certCodec.writeCertificate(certCodec.getLocation().toAbsolutePath(), this.getSecurityConfig().getCertificateFileName(), certificateHolder);
    }

    public class RefreshCACertificates
    implements Runnable {
        private final SCMSecurityProtocolClientSideTranslatorPB scmSecureClient;

        public RefreshCACertificates(SCMSecurityProtocolClientSideTranslatorPB client) {
            this.scmSecureClient = client;
        }

        @Override
        public void run() {
            try {
                List<String> rootCAPems = this.scmSecureClient.getAllRootCaCertificates();
                Set<X509Certificate> certList = SCMCertificateClient.this.getAllRootCaCerts();
                certList = certList.isEmpty() ? SCMCertificateClient.this.getAllCaCerts() : certList;
                List rootCAsFromLeaderSCM = OzoneSecurityUtil.convertToX509(rootCAPems);
                rootCAsFromLeaderSCM.removeAll(certList);
                if (rootCAsFromLeaderSCM.isEmpty()) {
                    LOG.info("CA certificates are not changed.");
                    return;
                }
                for (X509Certificate cert : rootCAsFromLeaderSCM) {
                    LOG.info("Fetched new root CA certificate {} from leader SCM", (Object)cert.getSerialNumber().toString());
                    SCMCertificateClient.this.storeCertificate(CertificateCodec.getPEMEncodedString((X509Certificate)cert), CAType.SUBORDINATE);
                }
                String scmCertId = SCMCertificateClient.this.getCertificate().getSerialNumber().toString();
                SCMCertificateClient.this.notifyNotificationReceivers(scmCertId, scmCertId);
            }
            catch (IOException e) {
                LOG.error("Failed to refresh CA certificates", (Throwable)e);
            }
        }
    }
}

