/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.om;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.server.JsonUtils;
import org.apache.hadoop.ozone.admin.om.OMAdmin;
import org.apache.hadoop.ozone.om.helpers.ServiceInfo;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.utils.FormattingCLIUtils;
import picocli.CommandLine;

@CommandLine.Command(name="roles", aliases={"getserviceroles"}, description={"List all OMs and their respective Ratis server roles"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class GetServiceRolesSubcommand
implements Callable<Void> {
    @CommandLine.ParentCommand
    private OMAdmin parent;
    @CommandLine.Option(names={"-id", "--service-id"}, description={"OM Service ID"}, required=false)
    private String omServiceId;
    @CommandLine.Option(names={"--json"}, defaultValue="false", description={"Format output as JSON"})
    private boolean json;
    @CommandLine.Option(names={"--table"}, defaultValue="false", description={"Format output as Table"})
    private boolean table;
    private OzoneManagerProtocol ozoneManagerClient;
    private static final String OM_ROLES_TITLE = "Ozone Manager Roles";
    private static final List<String> OM_ROLES_HEADER = Arrays.asList("Host Name", "Node ID", "Role");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        try {
            this.ozoneManagerClient = this.parent.createOmClient(this.omServiceId);
            if (this.json) {
                this.printOmServerRolesAsJson(this.ozoneManagerClient.getServiceList());
            } else if (this.table) {
                FormattingCLIUtils formattingCLIUtils = new FormattingCLIUtils(OM_ROLES_TITLE).addHeaders(OM_ROLES_HEADER);
                List serviceList = this.ozoneManagerClient.getServiceList();
                for (ServiceInfo serviceInfo : serviceList) {
                    OzoneManagerProtocolProtos.OMRoleInfo omRoleInfo = serviceInfo.getOmRoleInfo();
                    if (omRoleInfo == null || serviceInfo.getNodeType() != HddsProtos.NodeType.OM) continue;
                    formattingCLIUtils.addLine(new String[]{serviceInfo.getHostname(), omRoleInfo.getNodeId(), omRoleInfo.getServerRole()});
                }
                System.out.println(formattingCLIUtils.render());
            } else {
                this.printOmServerRoles(this.ozoneManagerClient.getServiceList());
            }
        }
        finally {
            if (this.ozoneManagerClient != null) {
                this.ozoneManagerClient.close();
            }
        }
        return null;
    }

    private void printOmServerRoles(List<ServiceInfo> serviceList) {
        for (ServiceInfo serviceInfo : serviceList) {
            OzoneManagerProtocolProtos.OMRoleInfo omRoleInfo = serviceInfo.getOmRoleInfo();
            if (omRoleInfo == null || serviceInfo.getNodeType() != HddsProtos.NodeType.OM) continue;
            System.out.println(omRoleInfo.getNodeId() + " : " + omRoleInfo.getServerRole() + " (" + serviceInfo.getHostname() + ")");
        }
    }

    private void printOmServerRolesAsJson(List<ServiceInfo> serviceList) throws IOException {
        ArrayList omServiceList = new ArrayList();
        for (final ServiceInfo serviceInfo : serviceList) {
            final OzoneManagerProtocolProtos.OMRoleInfo omRoleInfo = serviceInfo.getOmRoleInfo();
            if (omRoleInfo == null || serviceInfo.getNodeType() != HddsProtos.NodeType.OM) continue;
            HashMap<String, 1> omService = new HashMap<String, 1>();
            omService.put(omRoleInfo.getNodeId(), new HashMap<String, String>(){
                {
                    this.put("serverRole", omRoleInfo.getServerRole());
                    this.put("hostname", serviceInfo.getHostname());
                }
            });
            omServiceList.add(omService);
        }
        System.out.print(JsonUtils.toJsonStringWithDefaultPrettyPrinter(omServiceList));
    }

    @VisibleForTesting
    public void setOzoneManagerClient(OzoneManagerProtocol ozoneManagerClient) {
        this.ozoneManagerClient = ozoneManagerClient;
    }

    @VisibleForTesting
    public void setParent(OMAdmin parent) {
        this.parent = parent;
    }
}

