/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.codec;

import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;

public final class TokenIdentifierCodec
implements Codec<OzoneTokenIdentifier> {
    private static final Codec<OzoneTokenIdentifier> INSTANCE = new TokenIdentifierCodec();

    public static Codec<OzoneTokenIdentifier> get() {
        return INSTANCE;
    }

    private TokenIdentifierCodec() {
    }

    public Class<OzoneTokenIdentifier> getTypeClass() {
        return OzoneTokenIdentifier.class;
    }

    public byte[] toPersistedFormat(OzoneTokenIdentifier object) throws IOException {
        Preconditions.checkNotNull((Object)object, (Object)"Null object can't be converted to byte array.");
        return object.toProtoBuf().toByteArray();
    }

    public OzoneTokenIdentifier fromPersistedFormat(byte[] rawData) throws IOException {
        Preconditions.checkNotNull((Object)rawData, (Object)"Null byte array can't converted to real object.");
        try {
            return OzoneTokenIdentifier.readProtoBuf((byte[])rawData);
        }
        catch (IOException ex) {
            try {
                OzoneTokenIdentifier object = OzoneTokenIdentifier.newInstance();
                return object.fromUniqueSerializedKey(rawData);
            }
            catch (InvalidProtocolBufferException e) {
                throw new IllegalArgumentException("Can't encode the the raw data from the byte array", e);
            }
        }
        catch (BufferUnderflowException e) {
            throw new IllegalArgumentException("Can't encode the the raw data from the byte array", e);
        }
    }

    public OzoneTokenIdentifier copyObject(OzoneTokenIdentifier object) {
        return object;
    }
}

