/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.recon.api.types.DatanodePipeline;
import org.apache.hadoop.ozone.recon.api.types.DatanodeStorageReport;

@XmlAccessorType(value=XmlAccessType.FIELD)
public final class DatanodeMetadata {
    @XmlElement(name="uuid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String uuid;
    @XmlElement(name="hostname")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String hostname;
    @XmlElement(name="state")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private HddsProtos.NodeState state;
    @XmlElement(name="opState")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private HddsProtos.NodeOperationalState opState;
    @XmlElement(name="lastHeartbeat")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private long lastHeartbeat;
    @XmlElement(name="storageReport")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private DatanodeStorageReport datanodeStorageReport;
    @XmlElement(name="pipelines")
    private List<DatanodePipeline> pipelines;
    @XmlElement(name="containers")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private int containers;
    @XmlElement(name="openContainers")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private int openContainers;
    @XmlElement(name="leaderCount")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private int leaderCount;
    @XmlElement(name="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String version;
    @XmlElement(name="setupTime")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private long setupTime;
    @XmlElement(name="revision")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String revision;
    @XmlElement(name="layoutVersion")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private int layoutVersion;
    @XmlElement(name="networkLocation")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String networkLocation;

    private DatanodeMetadata(Builder builder) {
        this.hostname = builder.hostname;
        this.uuid = builder.uuid;
        this.state = builder.state;
        this.opState = builder.opState;
        this.lastHeartbeat = builder.lastHeartbeat;
        this.datanodeStorageReport = builder.datanodeStorageReport;
        this.pipelines = builder.pipelines;
        this.containers = builder.containers;
        this.openContainers = builder.openContainers;
        this.leaderCount = builder.leaderCount;
        this.version = builder.version;
        this.setupTime = builder.setupTime;
        this.revision = builder.revision;
        this.layoutVersion = builder.layoutVersion;
        this.networkLocation = builder.networkLocation;
    }

    public String getHostname() {
        return this.hostname;
    }

    public HddsProtos.NodeState getState() {
        return this.state;
    }

    public HddsProtos.NodeOperationalState getOperationalState() {
        return this.opState;
    }

    public long getLastHeartbeat() {
        return this.lastHeartbeat;
    }

    public DatanodeStorageReport getDatanodeStorageReport() {
        return this.datanodeStorageReport;
    }

    public List<DatanodePipeline> getPipelines() {
        return this.pipelines;
    }

    public int getContainers() {
        return this.containers;
    }

    public int getOpenContainers() {
        return this.openContainers;
    }

    public int getLeaderCount() {
        return this.leaderCount;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getVersion() {
        return this.version;
    }

    public long getSetupTime() {
        return this.setupTime;
    }

    public String getRevision() {
        return this.revision;
    }

    public int getLayoutVersion() {
        return this.layoutVersion;
    }

    public String getNetworkLocation() {
        return this.networkLocation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String hostname;
        private String uuid;
        private HddsProtos.NodeState state;
        private HddsProtos.NodeOperationalState opState;
        private long lastHeartbeat;
        private DatanodeStorageReport datanodeStorageReport;
        private List<DatanodePipeline> pipelines;
        private int containers = 0;
        private int openContainers = 0;
        private int leaderCount = 0;
        private String version;
        private long setupTime;
        private String revision;
        private int layoutVersion;
        private String networkLocation;

        public Builder setHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder setState(HddsProtos.NodeState state) {
            this.state = state;
            return this;
        }

        public Builder setOperationalState(HddsProtos.NodeOperationalState operationalState) {
            this.opState = operationalState;
            return this;
        }

        public Builder setLastHeartbeat(long lastHeartbeat) {
            this.lastHeartbeat = lastHeartbeat;
            return this;
        }

        public Builder setDatanodeStorageReport(DatanodeStorageReport datanodeStorageReport) {
            this.datanodeStorageReport = datanodeStorageReport;
            return this;
        }

        public Builder setPipelines(List<DatanodePipeline> pipelines) {
            this.pipelines = pipelines;
            return this;
        }

        public Builder setContainers(int containers) {
            this.containers = containers;
            return this;
        }

        public Builder setOpenContainers(int openContainers) {
            this.openContainers = openContainers;
            return this;
        }

        public Builder setLeaderCount(int leaderCount) {
            this.leaderCount = leaderCount;
            return this;
        }

        public Builder setUuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder setSetupTime(long setupTime) {
            this.setupTime = setupTime;
            return this;
        }

        public Builder setRevision(String revision) {
            this.revision = revision;
            return this;
        }

        public Builder setLayoutVersion(int layoutVersion) {
            this.layoutVersion = layoutVersion;
            return this;
        }

        public Builder setNetworkLocation(String networkLocation) {
            this.networkLocation = networkLocation;
            return this;
        }

        public DatanodeMetadata build() {
            Preconditions.checkNotNull((Object)this.hostname);
            Preconditions.checkNotNull((Object)this.state);
            return new DatanodeMetadata(this);
        }
    }
}

