/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;
import org.apache.hadoop.ozone.recon.tasks.NSSummaryTaskWithFSO;
import org.apache.hadoop.ozone.recon.tasks.NSSummaryTaskWithLegacy;
import org.apache.hadoop.ozone.recon.tasks.NSSummaryTaskWithOBS;
import org.apache.hadoop.ozone.recon.tasks.OMUpdateEventBatch;
import org.apache.hadoop.ozone.recon.tasks.ReconOmTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSSummaryTask
implements ReconOmTask {
    private static final Logger LOG = LoggerFactory.getLogger(NSSummaryTask.class);
    private final ReconNamespaceSummaryManager reconNamespaceSummaryManager;
    private final ReconOMMetadataManager reconOMMetadataManager;
    private final NSSummaryTaskWithFSO nsSummaryTaskWithFSO;
    private final NSSummaryTaskWithLegacy nsSummaryTaskWithLegacy;
    private final NSSummaryTaskWithOBS nsSummaryTaskWithOBS;
    private final OzoneConfiguration ozoneConfiguration;

    @Inject
    public NSSummaryTask(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager reconOMMetadataManager, OzoneConfiguration ozoneConfiguration) {
        this.reconNamespaceSummaryManager = reconNamespaceSummaryManager;
        this.reconOMMetadataManager = reconOMMetadataManager;
        this.ozoneConfiguration = ozoneConfiguration;
        this.nsSummaryTaskWithFSO = new NSSummaryTaskWithFSO(reconNamespaceSummaryManager, reconOMMetadataManager, ozoneConfiguration);
        this.nsSummaryTaskWithLegacy = new NSSummaryTaskWithLegacy(reconNamespaceSummaryManager, reconOMMetadataManager, ozoneConfiguration);
        this.nsSummaryTaskWithOBS = new NSSummaryTaskWithOBS(reconNamespaceSummaryManager, reconOMMetadataManager, ozoneConfiguration);
    }

    @Override
    public String getTaskName() {
        return "NSSummaryTask";
    }

    @Override
    public Pair<String, Boolean> process(OMUpdateEventBatch events) {
        boolean success = this.nsSummaryTaskWithFSO.processWithFSO(events);
        if (!success) {
            LOG.error("processWithFSO failed.");
        }
        if (!(success = this.nsSummaryTaskWithLegacy.processWithLegacy(events))) {
            LOG.error("processWithLegacy failed.");
        }
        if (!(success = this.nsSummaryTaskWithOBS.processWithOBS(events))) {
            LOG.error("processWithOBS failed.");
        }
        return new ImmutablePair((Object)this.getTaskName(), (Object)success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<String, Boolean> reprocess(OMMetadataManager omMetadataManager) {
        ArrayList<Callable<Boolean>> tasks = new ArrayList<Callable<Boolean>>();
        long startTime = System.nanoTime();
        try {
            this.reconNamespaceSummaryManager.clearNSSummaryTable();
        }
        catch (IOException ioEx) {
            LOG.error("Unable to clear NSSummary table in Recon DB. ", (Throwable)ioEx);
            return new ImmutablePair((Object)this.getTaskName(), (Object)false);
        }
        tasks.add(() -> this.nsSummaryTaskWithFSO.reprocessWithFSO(omMetadataManager));
        tasks.add(() -> this.nsSummaryTaskWithLegacy.reprocessWithLegacy(this.reconOMMetadataManager));
        tasks.add(() -> this.nsSummaryTaskWithOBS.reprocessWithOBS(this.reconOMMetadataManager));
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("Recon-NSSummaryTask-%d").build();
        ExecutorService executorService = Executors.newFixedThreadPool(2, threadFactory);
        try {
            List results = executorService.invokeAll(tasks);
            for (int i = 0; i < results.size(); ++i) {
                if (!((Boolean)results.get(i).get()).equals(false)) continue;
                ImmutablePair immutablePair = new ImmutablePair((Object)this.getTaskName(), (Object)false);
                return immutablePair;
            }
        }
        catch (InterruptedException ex) {
            LOG.error("Error while reprocessing NSSummary table in Recon DB.", (Throwable)ex);
            ImmutablePair immutablePair = new ImmutablePair((Object)this.getTaskName(), (Object)false);
            return immutablePair;
        }
        catch (ExecutionException ex2) {
            LOG.error("Error while reprocessing NSSummary table in Recon DB.", (Throwable)ex2);
            ImmutablePair immutablePair = new ImmutablePair((Object)this.getTaskName(), (Object)false);
            return immutablePair;
        }
        finally {
            executorService.shutdown();
            long endTime = System.nanoTime();
            long durationInMillis = TimeUnit.NANOSECONDS.toMillis(endTime - startTime);
            LOG.info("Task execution time: {} milliseconds", (Object)durationInMillis);
        }
        return new ImmutablePair((Object)this.getTaskName(), (Object)true);
    }
}

