/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import org.apache.hadoop.ozone.recon.api.types.UnhealthyContainerMetadata;
import org.hadoop.ozone.recon.schema.ContainerSchemaDefinition;

public class UnhealthyContainersResponse {
    @JsonProperty(value="missingCount")
    private long missingCount = 0L;
    @JsonProperty(value="underReplicatedCount")
    private long underReplicatedCount = 0L;
    @JsonProperty(value="overReplicatedCount")
    private long overReplicatedCount = 0L;
    @JsonProperty(value="misReplicatedCount")
    private long misReplicatedCount = 0L;
    @JsonProperty(value="negativeSizeCount")
    private long negativeSizeCount = 0L;
    @JsonProperty(value="containers")
    private Collection<UnhealthyContainerMetadata> containers;

    public UnhealthyContainersResponse(Collection<UnhealthyContainerMetadata> containers) {
        this.containers = containers;
    }

    public void setSummaryCount(String state, long count) {
        if (state.equals(ContainerSchemaDefinition.UnHealthyContainerStates.MISSING.toString())) {
            this.missingCount = count;
        } else if (state.equals(ContainerSchemaDefinition.UnHealthyContainerStates.OVER_REPLICATED.toString())) {
            this.overReplicatedCount = count;
        } else if (state.equals(ContainerSchemaDefinition.UnHealthyContainerStates.UNDER_REPLICATED.toString())) {
            this.underReplicatedCount = count;
        } else if (state.equals(ContainerSchemaDefinition.UnHealthyContainerStates.MIS_REPLICATED.toString())) {
            this.misReplicatedCount = count;
        } else if (state.equals(ContainerSchemaDefinition.UnHealthyContainerStates.NEGATIVE_SIZE.toString())) {
            this.negativeSizeCount = count;
        }
    }

    public long getMissingCount() {
        return this.missingCount;
    }

    public long getUnderReplicatedCount() {
        return this.underReplicatedCount;
    }

    public long getOverReplicatedCount() {
        return this.overReplicatedCount;
    }

    public long getMisReplicatedCount() {
        return this.misReplicatedCount;
    }

    public long getNegativeSizeCount() {
        return this.negativeSizeCount;
    }

    public Collection<UnhealthyContainerMetadata> getContainers() {
        return this.containers;
    }
}

