/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api;

import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.hadoop.ozone.recon.api.AdminOnly;
import org.apache.hadoop.ozone.recon.api.InternalOnly;
import org.apache.hadoop.ozone.recon.api.types.EntityReadAccessHeatMapResponse;
import org.apache.hadoop.ozone.recon.api.types.FeatureProvider;
import org.apache.hadoop.ozone.recon.heatmap.HeatMapServiceImpl;

@Path(value="/heatmap")
@Produces(value={"application/json"})
@AdminOnly
@InternalOnly(feature="Heatmap", description="Heatmap feature has dependency on heatmap provider service component implementation.")
public class AccessHeatMapEndpoint {
    private HeatMapServiceImpl heatMapService;

    @Inject
    public AccessHeatMapEndpoint(HeatMapServiceImpl heatMapService) {
        this.heatMapService = heatMapService;
    }

    @GET
    @Path(value="/readaccess")
    public Response getReadAccessMetaData(@QueryParam(value="path") String path, @DefaultValue(value="key") @QueryParam(value="entityType") String entityType, @DefaultValue(value="24H") @QueryParam(value="startDate") String startDate) {
        AccessHeatMapEndpoint.checkIfHeatMapFeatureIsEnabled();
        EntityReadAccessHeatMapResponse entityReadAccessHeatMapResponse = null;
        try {
            entityReadAccessHeatMapResponse = this.heatMapService.retrieveData(path, entityType, startDate);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return Response.ok((Object)entityReadAccessHeatMapResponse).build();
    }

    private static void checkIfHeatMapFeatureIsEnabled() {
        FeatureProvider.Feature heatMapFeature = null;
        List<FeatureProvider.Feature> allDisabledFeatures = FeatureProvider.getAllDisabledFeatures();
        for (FeatureProvider.Feature feature : allDisabledFeatures) {
            if (!"HeatMap".equals(feature.getFeatureName())) continue;
            heatMapFeature = feature;
            break;
        }
        if (null != heatMapFeature) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }
}

