/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.container;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.cli.OzoneAdmin;
import org.apache.hadoop.hdds.cli.SubcommandWithParent;
import org.apache.hadoop.hdds.scm.cli.container.CloseSubcommand;
import org.apache.hadoop.hdds.scm.cli.container.CreateSubcommand;
import org.apache.hadoop.hdds.scm.cli.container.InfoSubcommand;
import org.apache.hadoop.hdds.scm.cli.container.ListSubcommand;
import org.apache.hadoop.hdds.scm.cli.container.ReportSubcommand;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import picocli.CommandLine;

@CommandLine.Command(name="container", description={"Container specific operations"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class, subcommands={ListSubcommand.class, InfoSubcommand.class, CreateSubcommand.class, CloseSubcommand.class, ReportSubcommand.class})
public class ContainerCommands
implements Callable<Void>,
SubcommandWithParent {
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;

    @Override
    public Void call() throws Exception {
        GenericCli.missingSubcommand((CommandLine.Model.CommandSpec)this.spec);
        return null;
    }

    public Class<?> getParentType() {
        return OzoneAdmin.class;
    }

    public static void checkContainerExists(ScmClient scmClient, long containerId) throws IOException {
        ContainerInfo container = scmClient.getContainer(containerId);
        if (container == null) {
            throw new IllegalArgumentException("No such container " + containerId);
        }
    }
}

