/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.remote.vault.auth;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ozone.s3.remote.vault.auth.AppRoleAuth;
import org.apache.hadoop.ozone.s3.remote.vault.auth.Auth;
import org.apache.hadoop.ozone.s3.remote.vault.auth.DirectTokenAuth;

public enum AuthType {
    APP_ROLE,
    TOKEN;


    public static Auth fromConf(Configuration conf) {
        AuthType authType = AuthType.valueOf(conf.get("ozone.secret.s3.store.remote.vault.auth").toUpperCase());
        switch (authType) {
            case TOKEN: {
                String token = conf.get("ozone.secret.s3.store.remote.vault.auth.token");
                return new DirectTokenAuth(() -> token);
            }
            case APP_ROLE: {
                String rolePath = conf.get("ozone.secret.s3.store.remote.vault.auth.approle.path");
                String roleId = conf.get("ozone.secret.s3.store.remote.vault.auth.approle.id");
                String roleSecret = conf.get("ozone.secret.s3.store.remote.vault.auth.approle.secret");
                return new AppRoleAuth(rolePath, roleId, roleSecret);
            }
        }
        throw new IllegalStateException("Vault authentication method doesn't specified.");
    }
}

