/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.signature;

import javax.enterprise.context.RequestScoped;

@RequestScoped
public class SignatureInfo {
    private Version version;
    private String date;
    private String dateTime;
    private String awsAccessId;
    private String signature;
    private String signedHeaders;
    private String credentialScope;
    private String algorithm;
    private boolean signPayload = true;
    private String unfilteredURI = null;
    private String stringToSign = null;

    public SignatureInfo() {
    }

    public SignatureInfo(Version version, String date, String dateTime, String awsAccessId, String signature, String signedHeaders, String credentialScope, String algorithm, boolean signPayload) {
        this.initialize(version, date, dateTime, awsAccessId, signature, signedHeaders, credentialScope, algorithm, signPayload, null, null);
    }

    public void initialize(SignatureInfo signatureInfo) {
        this.initialize(signatureInfo.getVersion(), signatureInfo.getDate(), signatureInfo.getDateTime(), signatureInfo.getAwsAccessId(), signatureInfo.getSignature(), signatureInfo.getSignedHeaders(), signatureInfo.getCredentialScope(), signatureInfo.getAlgorithm(), signatureInfo.isSignPayload(), signatureInfo.getUnfilteredURI(), signatureInfo.getStringToSign());
    }

    public void initialize(Version version, String date, String dateTime, String awsAccessId, String signature, String signedHeaders, String credentialScope, String algorithm, boolean signPayload, String uri, String stringToSign) {
        this.version = version;
        this.date = date;
        this.dateTime = dateTime;
        this.awsAccessId = awsAccessId;
        this.signature = signature;
        this.signedHeaders = signedHeaders;
        this.credentialScope = credentialScope;
        this.algorithm = algorithm;
        this.signPayload = signPayload;
        this.unfilteredURI = uri;
        this.stringToSign = stringToSign;
    }

    public String getAwsAccessId() {
        return this.awsAccessId;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getDate() {
        return this.date;
    }

    public String getSignedHeaders() {
        return this.signedHeaders;
    }

    public String getCredentialScope() {
        return this.credentialScope;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean isSignPayload() {
        return this.signPayload;
    }

    public String getDateTime() {
        return this.dateTime;
    }

    public String getUnfilteredURI() {
        return this.unfilteredURI;
    }

    public String getStringToSign() {
        return this.stringToSign;
    }

    public void setUnfilteredURI(String uri) {
        this.unfilteredURI = uri;
    }

    public void setStrToSign(String strToSign) {
        this.stringToSign = strToSign;
    }

    public static enum Version {
        NONE,
        V4,
        V2;

    }
}

