/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.exception;

import java.util.function.Function;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class S3ErrorTable {
    private static final Logger LOG = LoggerFactory.getLogger(S3ErrorTable.class);
    public static final OS3Exception INVALID_URI = new OS3Exception("InvalidURI", "Couldn't parse the specified URI.", 400);
    public static final OS3Exception NO_SUCH_VOLUME = new OS3Exception("NoSuchVolume", "The specified volume does not exist", 404);
    public static final OS3Exception NO_SUCH_BUCKET = new OS3Exception("NoSuchBucket", "The specified bucket does not exist", 404);
    public static final OS3Exception AUTH_PROTOCOL_NOT_SUPPORTED = new OS3Exception("AuthProtocolNotSupported", "Auth protocol used for this request is not supported.", 400);
    public static final OS3Exception S3_AUTHINFO_CREATION_ERROR = new OS3Exception("InvalidRequest", "Error creating s3 auth info. The request may not be signed using AWS V4 signing algorithm, or might be invalid", 403);
    public static final OS3Exception BUCKET_NOT_EMPTY = new OS3Exception("BucketNotEmpty", "The bucket you tried to delete is not empty. If you are using --force option to delete all objects in the bucket, please ensure that the bucket layout is OBJECT_STORE or that the bucket is completely empty before delete.", 409);
    public static final OS3Exception MALFORMED_HEADER = new OS3Exception("AuthorizationHeaderMalformed", "The authorization header you provided is invalid.", 400);
    public static final OS3Exception NO_SUCH_KEY = new OS3Exception("NoSuchKey", "The specified key does not exist", 404);
    public static final OS3Exception INVALID_ARGUMENT = new OS3Exception("InvalidArgument", "Invalid Argument", 400);
    public static final OS3Exception INVALID_REQUEST = new OS3Exception("InvalidRequest", "Invalid Request", 400);
    public static final OS3Exception INVALID_RANGE = new OS3Exception("InvalidRange", "The requested range is not satisfiable", 416);
    public static final OS3Exception NO_SUCH_UPLOAD = new OS3Exception("NoSuchUpload", "The specified multipart upload does not exist. The upload ID might be invalid, or the multipart upload might have been aborted or completed.", 404);
    public static final OS3Exception INVALID_BUCKET_NAME = new OS3Exception("InvalidBucketName", "The specified bucket is not valid.", 400);
    public static final OS3Exception INVALID_PART = new OS3Exception("InvalidPart", "One or more of the specified parts could not be found. The part might not have been uploaded, or the specified entity tag might not have matched the part's entity tag.", 400);
    public static final OS3Exception INVALID_PART_ORDER = new OS3Exception("InvalidPartOrder", "The list of parts was not in ascending order. The parts list must be specified in order by part number.", 400);
    public static final OS3Exception ENTITY_TOO_SMALL = new OS3Exception("EntityTooSmall", "Your proposed upload is smaller than the minimum allowed object size. Each part must be at least 5 MB in size, except the last part.", 400);
    public static final OS3Exception INTERNAL_ERROR = new OS3Exception("InternalError", "We encountered an internal error. Please try again.", 500);
    public static final OS3Exception ACCESS_DENIED = new OS3Exception("AccessDenied", "User doesn't have the right to access this resource.", 403);
    public static final OS3Exception PRECOND_FAILED = new OS3Exception("PreconditionFailed", "At least one of the pre-conditions you specified did not hold", 412);
    public static final OS3Exception NOT_IMPLEMENTED = new OS3Exception("NotImplemented", "This part of feature is not implemented yet.", 501);
    public static final OS3Exception NO_OVERWRITE = new OS3Exception("Conflict", "Cannot overwrite file with directory", 409);
    public static final OS3Exception METADATA_TOO_LARGE = new OS3Exception("MetadataTooLarge", "Illegal user defined metadata. Combined size exceeds the maximum allowed metadata size of 2KB", 400);
    public static final OS3Exception BUCKET_ALREADY_EXISTS = new OS3Exception("BucketAlreadyExists", "The requested bucket name is not available as it already exists.", 409);
    private static Function<Exception, OS3Exception> generateInternalError = e -> new OS3Exception("InternalError", e.getMessage(), 500);

    private S3ErrorTable() {
    }

    public static OS3Exception newError(OS3Exception e, String resource) {
        return S3ErrorTable.newError(e, resource, null);
    }

    public static OS3Exception newError(OS3Exception e, String resource, Exception ex) {
        OS3Exception err = new OS3Exception(e.getCode(), e.getErrorMessage(), e.getHttpCode());
        err.setResource(resource);
        if (e.getHttpCode() == 500) {
            LOG.error("Internal Error: {}", (Object)err.toXml(), (Object)ex);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(err.toXml(), (Throwable)ex);
        }
        return err;
    }

    public static OS3Exception getInternalError(Exception e) {
        return generateInternalError.apply(e);
    }
}

