/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.exception;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="Error")
@XmlAccessorType(value=XmlAccessType.NONE)
public class OS3Exception
extends Exception {
    private static final Logger LOG = LoggerFactory.getLogger(OS3Exception.class);
    private static ObjectMapper mapper = new XmlMapper();
    @XmlElement(name="Code")
    private String code;
    @XmlElement(name="Message")
    private String errorMessage;
    @XmlElement(name="Resource")
    private String resource;
    @XmlElement(name="RequestId")
    private String requestId;
    @XmlTransient
    private int httpCode;

    public OS3Exception() {
    }

    public OS3Exception(String codeVal, String messageVal, String requestIdVal, String resourceVal) {
        this.code = codeVal;
        this.errorMessage = messageVal;
        this.requestId = requestIdVal;
        this.resource = resourceVal;
    }

    public OS3Exception(String codeVal, String messageVal, int httpCode) {
        this.code = codeVal;
        this.errorMessage = messageVal;
        this.httpCode = httpCode;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public int getHttpCode() {
        return this.httpCode;
    }

    public void setHttpCode(int httpCode) {
        this.httpCode = httpCode;
    }

    public String toXml() {
        try {
            String val = mapper.writeValueAsString((Object)this);
            LOG.debug("toXml val is {}", (Object)val);
            String xmlLine = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + val;
            return xmlLine;
        }
        catch (Exception ex) {
            LOG.error("Exception occurred", (Throwable)ex);
            String formatString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Error><Code>%s</Code><Message>%s</Message><Resource>%s</Resource><RequestId>%s</RequestId></Error>";
            return String.format(formatString, this.getCode(), this.getErrorMessage(), this.getResource(), this.getRequestId());
        }
    }

    static {
        mapper.registerModule((Module)new JaxbAnnotationModule());
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
    }
}

