/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.ozone.s3.endpoint.S3Owner;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="AccessControlPolicy", namespace="http://s3.amazonaws.com/doc/2006-03-01/")
public class S3BucketAcl {
    @XmlElement(name="Owner")
    private S3Owner owner;
    @XmlElement(name="AccessControlList")
    private AccessControlList aclList;

    public S3Owner getOwner() {
        return this.owner;
    }

    public void setOwner(S3Owner owner) {
        this.owner = owner;
    }

    public AccessControlList getAclList() {
        return this.aclList;
    }

    public void setAclList(AccessControlList aclList) {
        this.aclList = aclList;
    }

    public String toString() {
        return "GetBucketAclResponse{owner=" + this.owner + ", aclList=" + this.aclList + '}';
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlRootElement(name="Grantee")
    public static class Grantee {
        @XmlElement(name="DisplayName")
        private String displayName;
        @XmlElement(name="ID")
        private String id;
        @XmlAttribute(name="xsi:type")
        private String xsiType = "CanonicalUser";
        @XmlAttribute(name="xmlns:xsi")
        private String xsiNs = "http://www.w3.org/2001/XMLSchema-instance";

        public String getXsiNs() {
            return this.xsiNs;
        }

        public String getXsiType() {
            return this.xsiType;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String name) {
            this.displayName = name;
        }

        public void setXsiType(String type) {
            this.xsiType = type;
        }

        public void setXsiNs(String ns) {
            this.xsiNs = ns;
        }

        public String toString() {
            return "Grantee{displayName='" + this.displayName + '\'' + ", id='" + this.id + '\'' + ", xsiType='" + this.xsiType + '\'' + ", xsiNs='" + this.xsiNs + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Grantee grantee = (Grantee)o;
            return Objects.equals(this.displayName, grantee.displayName) && Objects.equals(this.id, grantee.id) && Objects.equals(this.xsiType, grantee.xsiType) && Objects.equals(this.xsiNs, grantee.xsiNs);
        }

        public int hashCode() {
            return Objects.hash(this.displayName, this.id, this.xsiType, this.xsiNs);
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlRootElement(name="Grant")
    public static class Grant {
        @XmlElement(name="Grantee")
        private Grantee grantee;
        @XmlElement(name="Permission")
        private String permission;

        public String getPermission() {
            return this.permission;
        }

        public void setPermission(String permission) {
            this.permission = permission;
        }

        public Grantee getGrantee() {
            return this.grantee;
        }

        public void setGrantee(Grantee grantee) {
            this.grantee = grantee;
        }

        public String toString() {
            return "Grant{grantee=" + this.grantee + ", permission='" + this.permission + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Grant grant = (Grant)o;
            return Objects.equals(this.grantee, grant.grantee) && Objects.equals(this.permission, grant.permission);
        }

        public int hashCode() {
            return Objects.hash(this.grantee, this.permission);
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlRootElement(name="AccessControlList")
    public static class AccessControlList {
        @XmlElement(name="Grant")
        private List<Grant> grantList = new ArrayList<Grant>();

        public void addGrant(Grant grant) {
            this.grantList.add(grant);
        }

        public List<Grant> getGrantList() {
            return this.grantList;
        }

        public AccessControlList(List<Grant> grants) {
            this.grantList = grants;
        }

        public AccessControlList() {
        }

        public String toString() {
            return "AccessControlList{grantList=" + this.grantList + '}';
        }
    }
}

