/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.tenant;

import java.io.IOException;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.tenant.TenantHandler;
import picocli.CommandLine;

@CommandLine.Command(name="get-secret", aliases={"getsecret"}, description={"Get secret given tenant user accessId. This differs from `ozone s3 getsecret` that this would not generate secret when the given access ID doesn't exist."})
public class TenantGetSecretHandler
extends TenantHandler {
    @CommandLine.Parameters(description={"Access ID"}, arity="1..1")
    private String accessId;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        S3SecretValue accessIdSecretKeyPair = client.getObjectStore().getS3Secret(this.accessId, false);
        this.out().printf("export AWS_ACCESS_KEY_ID='%s'%n", accessIdSecretKeyPair.getAwsAccessKey());
        this.out().printf("export AWS_SECRET_ACCESS_KEY='%s'%n", accessIdSecretKeyPair.getAwsSecret());
    }
}

