/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.checknative;

import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.io.erasurecode.ErasureCodeNative;
import org.apache.hadoop.util.NativeCodeLoader;
import picocli.CommandLine;

@CommandLine.Command(name="ozone checknative", description={"Checks if native libraries are loaded"})
public class CheckNative
extends GenericCli {
    public static void main(String[] argv) {
        new CheckNative().run(argv);
    }

    public Void call() throws Exception {
        boolean nativeHadoopLoaded = NativeCodeLoader.isNativeCodeLoaded();
        String hadoopLibraryName = "";
        String isalDetail = "";
        boolean isalLoaded = false;
        if (nativeHadoopLoaded) {
            hadoopLibraryName = NativeCodeLoader.getLibraryName();
            isalDetail = ErasureCodeNative.getLoadingFailureReason();
            if (isalDetail != null) {
                isalLoaded = false;
            } else {
                isalDetail = ErasureCodeNative.getLibraryName();
                isalLoaded = true;
            }
        }
        System.out.println("Native library checking:");
        System.out.printf("hadoop:  %b %s%n", nativeHadoopLoaded, hadoopLibraryName);
        System.out.printf("ISA-L:   %b %s%n", isalLoaded, isalDetail);
        return null;
    }
}

