/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell;

import java.util.Optional;
import org.apache.hadoop.fs.ozone.OzoneClientUtils;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.ozone.OzoneConfigKeys;
import picocli.CommandLine;

public abstract class ReplicationOptions {
    private ReplicationType type;
    private String replication;

    public Optional<ReplicationConfig> fromParams(ConfigurationSource conf) {
        if (this.replication == null && this.type == null) {
            return Optional.empty();
        }
        if (ReplicationType.RATIS == this.type && this.replication == null) {
            this.replication = conf.get("ozone.replication", OzoneConfigKeys.OZONE_REPLICATION_DEFAULT);
        }
        return Optional.of(ReplicationConfig.parseWithoutFallback((ReplicationType)this.type, (String)this.replication, (ConfigurationSource)conf));
    }

    public Optional<ReplicationConfig> fromConfig(ConfigurationSource conf) {
        ReplicationType defaultType = Optional.ofNullable(conf.get("ozone.replication.type")).map(ReplicationType::valueOf).orElse(null);
        String defaultReplication = conf.get("ozone.replication", OzoneConfigKeys.OZONE_REPLICATION_DEFAULT);
        return Optional.ofNullable(OzoneClientUtils.validateAndGetClientReplicationConfig((ReplicationType)defaultType, (String)defaultReplication, (ConfigurationSource)conf));
    }

    public ReplicationConfig fromParamsOrConfig(ConfigurationSource conf) {
        return this.fromParams(conf).orElseGet(() -> this.fromConfig(conf).orElse(null));
    }

    @CommandLine.Option(names={"--replication", "-r"}, description={"Replication definition. Valid values are replication type-specific.  For RATIS: ONE or THREE. In case of EC, pass CODEC-DATA-PARITY-CHUNKSIZE,  e.g. rs-3-2-1024k, rs-6-3-1024k, rs-10-4-1024k"})
    public void setReplication(String replication) {
        this.replication = replication;
    }

    public void setType(String type) {
        try {
            ReplicationType replicationType = ReplicationType.valueOf((String)type);
            if (replicationType == ReplicationType.CHAINED || replicationType == ReplicationType.STAND_ALONE) {
                throw new IllegalArgumentException(String.format("Unsupported replication type %s", replicationType.name()));
            }
            this.type = replicationType;
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(String.format("Invalid value '%s' for option '--type'. %s. Supported values are: RATIS, EC.", type, ex.getMessage()));
        }
    }
}

