/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.repair.om;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.SubcommandWithParent;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.hdds.utils.db.StringCodec;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksDB;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksIterator;
import org.apache.hadoop.ozone.debug.RocksDBUtils;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.repair.RDBRepair;
import org.apache.hadoop.ozone.shell.bucket.BucketUri;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import picocli.CommandLine;

@CommandLine.Command(name="snapshot", description={"CLI to update global and path previous snapshot for a snapshot in case snapshot chain is corrupted."})
public class SnapshotRepair
implements Callable<Void>,
SubcommandWithParent {
    @CommandLine.Spec
    private static CommandLine.Model.CommandSpec spec;
    @CommandLine.ParentCommand
    private RDBRepair parent;
    @CommandLine.Mixin
    private BucketUri bucketUri;
    @CommandLine.Parameters(description={"Snapshot name to update"}, index="1")
    private String snapshotName;
    @CommandLine.Option(names={"--global-previous", "--gp"}, required=true, description={"Global previous snapshotId to set for the given snapshot"})
    private UUID globalPreviousSnapshotId;
    @CommandLine.Option(names={"--path-previous", "--pp"}, required=true, description={"Path previous snapshotId to set for the given snapshot"})
    private UUID pathPreviousSnapshotId;
    @CommandLine.Option(names={"--dry-run"}, required=true, description={"To dry-run the command."}, defaultValue="true")
    private boolean dryRun;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Void call() throws Exception {
        ArrayList<ColumnFamilyHandle> cfHandleList = new ArrayList<ColumnFamilyHandle>();
        List<ColumnFamilyDescriptor> cfDescList = RocksDBUtils.getColumnFamilyDescriptors(this.parent.getDbPath());
        try (ManagedRocksDB db = ManagedRocksDB.open((String)this.parent.getDbPath(), cfDescList, cfHandleList);){
            ColumnFamilyHandle snapshotInfoCfh = this.getSnapshotInfoCfh(cfHandleList);
            if (snapshotInfoCfh == null) {
                System.err.println("snapshotInfoTable is not in a column family in DB for the given path.");
                Void void_ = null;
                return void_;
            }
            String snapshotInfoTableKey = SnapshotInfo.getTableKey((String)this.bucketUri.getValue().getVolumeName(), (String)this.bucketUri.getValue().getBucketName(), (String)this.snapshotName);
            SnapshotInfo snapshotInfo = this.getSnapshotInfo(db, snapshotInfoCfh, snapshotInfoTableKey);
            if (snapshotInfo == null) {
                System.err.println(this.snapshotName + " does not exist for given bucketUri: " + "/" + this.bucketUri.getValue().getVolumeName() + "/" + this.bucketUri.getValue().getBucketName());
                Void void_ = null;
                return void_;
            }
            Set<UUID> snapshotIdSet = this.getSnapshotIdSet(db, snapshotInfoCfh);
            if (Objects.equals(snapshotInfo.getSnapshotId(), this.globalPreviousSnapshotId)) {
                System.err.println("globalPreviousSnapshotId: '" + this.globalPreviousSnapshotId + "' is equal to given snapshot's ID: '" + snapshotInfo.getSnapshotId() + "'.");
                Void void_ = null;
                return void_;
            }
            if (Objects.equals(snapshotInfo.getSnapshotId(), this.pathPreviousSnapshotId)) {
                System.err.println("pathPreviousSnapshotId: '" + this.pathPreviousSnapshotId + "' is equal to given snapshot's ID: '" + snapshotInfo.getSnapshotId() + "'.");
                Void void_ = null;
                return void_;
            }
            if (!snapshotIdSet.contains(this.globalPreviousSnapshotId)) {
                System.err.println("globalPreviousSnapshotId: '" + this.globalPreviousSnapshotId + "' does not exist in snapshotInfoTable.");
                Void void_ = null;
                return void_;
            }
            if (!snapshotIdSet.contains(this.pathPreviousSnapshotId)) {
                System.err.println("pathPreviousSnapshotId: '" + this.pathPreviousSnapshotId + "' does not exist in snapshotInfoTable.");
                Void void_ = null;
                return void_;
            }
            snapshotInfo.setGlobalPreviousSnapshotId(this.globalPreviousSnapshotId);
            snapshotInfo.setPathPreviousSnapshotId(this.pathPreviousSnapshotId);
            if (this.dryRun) {
                System.out.println("SnapshotInfo would be updated to : " + snapshotInfo);
                return null;
            }
            byte[] snapshotInfoBytes = SnapshotInfo.getCodec().toPersistedFormat((Object)snapshotInfo);
            ((RocksDB)db.get()).put(snapshotInfoCfh, StringCodec.get().toPersistedFormat(snapshotInfoTableKey), snapshotInfoBytes);
            System.out.println("Snapshot Info is updated to : " + this.getSnapshotInfo(db, snapshotInfoCfh, snapshotInfoTableKey));
            return null;
        }
        catch (RocksDBException exception) {
            System.err.println("Failed to update the RocksDB for the given path: " + this.parent.getDbPath());
            System.err.println("Make sure that Ozone entity (OM, SCM or DN) is not running for the give dbPath and current host.");
            System.err.println((Object)exception);
            return null;
        }
        finally {
            IOUtils.closeQuietly(cfHandleList);
        }
    }

    private Set<UUID> getSnapshotIdSet(ManagedRocksDB db, ColumnFamilyHandle snapshotInfoCfh) throws IOException {
        HashSet<UUID> snapshotIdSet = new HashSet<UUID>();
        try (ManagedRocksIterator iterator = new ManagedRocksIterator(((RocksDB)db.get()).newIterator(snapshotInfoCfh));){
            ((RocksIterator)iterator.get()).seekToFirst();
            while (((RocksIterator)iterator.get()).isValid()) {
                SnapshotInfo snapshotInfo = (SnapshotInfo)SnapshotInfo.getCodec().fromPersistedFormat(((RocksIterator)iterator.get()).value());
                snapshotIdSet.add(snapshotInfo.getSnapshotId());
                ((RocksIterator)iterator.get()).next();
            }
        }
        return snapshotIdSet;
    }

    private ColumnFamilyHandle getSnapshotInfoCfh(List<ColumnFamilyHandle> cfHandleList) throws RocksDBException {
        byte[] nameBytes = "snapshotInfoTable".getBytes(StandardCharsets.UTF_8);
        for (ColumnFamilyHandle cf : cfHandleList) {
            if (!Arrays.equals(cf.getName(), nameBytes)) continue;
            return cf;
        }
        return null;
    }

    private SnapshotInfo getSnapshotInfo(ManagedRocksDB db, ColumnFamilyHandle snapshotInfoCfh, String snapshotInfoLKey) throws IOException, RocksDBException {
        byte[] bytes = ((RocksDB)db.get()).get(snapshotInfoCfh, StringCodec.get().toPersistedFormat(snapshotInfoLKey));
        return bytes != null ? (SnapshotInfo)SnapshotInfo.getCodec().fromPersistedFormat(bytes) : null;
    }

    public Class<?> getParentType() {
        return RDBRepair.class;
    }
}

