/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.container;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerMetadataInspector;
import org.apache.hadoop.ozone.container.keyvalue.helpers.BlockUtils;
import org.apache.hadoop.ozone.container.metadata.DatanodeStore;
import org.apache.hadoop.ozone.debug.container.ContainerCommands;
import picocli.CommandLine;

@CommandLine.Command(name="inspect", description={"Check the metadata of all container replicas on this datanode."})
public class InspectSubcommand
implements Callable<Void> {
    @CommandLine.ParentCommand
    private ContainerCommands parent;

    @Override
    public Void call() throws IOException {
        OzoneConfiguration conf = this.parent.getOzoneConf();
        this.parent.loadContainersFromVolumes();
        KeyValueContainerMetadataInspector inspector = new KeyValueContainerMetadataInspector(KeyValueContainerMetadataInspector.Mode.INSPECT);
        for (Container container : this.parent.getController().getContainers()) {
            ContainerData data = container.getContainerData();
            if (!(data instanceof KeyValueContainerData)) continue;
            KeyValueContainerData kvData = (KeyValueContainerData)data;
            try {
                DatanodeStore store = BlockUtils.getUncachedDatanodeStore((KeyValueContainerData)kvData, (ConfigurationSource)conf, (boolean)true);
                Throwable throwable = null;
                try {
                    String json = inspector.process((ContainerData)kvData, store, null);
                    System.out.println(json);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (store == null) continue;
                    if (throwable != null) {
                        try {
                            store.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    store.close();
                }
            }
            catch (IOException e) {
                System.err.print("Failed to inspect container " + kvData.getContainerID() + ": ");
                e.printStackTrace();
            }
        }
        return null;
    }
}

