/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.reconfig;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.cli.OzoneAdmin;
import org.apache.hadoop.hdds.cli.SubcommandWithParent;
import org.apache.hadoop.hdds.scm.cli.ContainerOperationClient;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.ozone.admin.reconfig.ReconfigurePropertiesSubcommand;
import org.apache.hadoop.ozone.admin.reconfig.ReconfigureStartSubcommand;
import org.apache.hadoop.ozone.admin.reconfig.ReconfigureStatusSubcommand;
import org.apache.hadoop.ozone.admin.reconfig.ReconfigureSubCommandUtil;
import picocli.CommandLine;

@CommandLine.Command(name="reconfig", description={"Dynamically reconfigure server without restarting it"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class, subcommands={ReconfigureStartSubcommand.class, ReconfigureStatusSubcommand.class, ReconfigurePropertiesSubcommand.class})
public class ReconfigureCommands
implements Callable<Void>,
SubcommandWithParent {
    @CommandLine.ParentCommand
    private OzoneAdmin parent;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"--address"}, description={"node address: <ip:port> or <hostname:port>."}, required=false)
    private String address;
    @CommandLine.Option(names={"--in-service-datanodes"}, description={"If set, the client will send reconfiguration requests to all available DataNodes in the IN_SERVICE operational state."}, required=false)
    private boolean batchReconfigDatanodes;

    @Override
    public Void call() throws Exception {
        GenericCli.missingSubcommand((CommandLine.Model.CommandSpec)this.spec);
        return null;
    }

    public String getAddress() {
        return this.address;
    }

    public Class<?> getParentType() {
        return OzoneAdmin.class;
    }

    public boolean isBatchReconfigDatanodes() {
        return this.batchReconfigDatanodes;
    }

    public List<String> getAllOperableNodesClientRpcAddress() {
        List<String> nodes;
        try (ContainerOperationClient scmClient = new ContainerOperationClient(this.parent.getOzoneConf());){
            nodes = ReconfigureSubCommandUtil.getAllOperableNodesClientRpcAddress((ScmClient)scmClient);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return nodes;
    }
}

