/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.reconfig;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.ozone.admin.reconfig.ReconfigureCommands;
import org.apache.hadoop.ozone.admin.reconfig.ReconfigureSubCommandUtil;
import picocli.CommandLine;

public abstract class AbstractReconfigureSubCommand
implements Callable<Void> {
    @CommandLine.ParentCommand
    private ReconfigureCommands parent;

    @Override
    public Void call() throws Exception {
        if (this.parent.isBatchReconfigDatanodes()) {
            ExecutorService executorService = Executors.newFixedThreadPool(5);
            List<String> nodes = this.parent.getAllOperableNodesClientRpcAddress();
            ReconfigureSubCommandUtil.parallelExecute(executorService, nodes, this::executeCommand);
        } else {
            if (this.parent.getAddress() == null || this.parent.getAddress().isEmpty()) {
                System.out.println("Error: --address must be specified if --in-service-datanodes is not given.");
                return null;
            }
            this.executeCommand(this.parent.getAddress());
        }
        return null;
    }

    protected abstract void executeCommand(String var1);
}

