/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.security.acl;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.PrefixManager;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneNativeAuthorizer;
import org.apache.hadoop.util.ReflectionUtils;

public final class OzoneAuthorizerFactory {
    private OzoneAuthorizerFactory() {
    }

    public static IAccessAuthorizer forOM(OzoneManager om) {
        return OzoneAuthorizerFactory.create(om, om.getKeyManager(), om.getPrefixManager());
    }

    public static IAccessAuthorizer forSnapshot(OzoneManager om, KeyManager keyManager, PrefixManager prefixManager) {
        return om.getAccessAuthorizer().isNative() ? OzoneAuthorizerFactory.create(om, keyManager, prefixManager) : om.getAccessAuthorizer();
    }

    private static IAccessAuthorizer create(OzoneManager om, KeyManager km, PrefixManager pm) {
        if (!om.getAclsEnabled()) {
            return OzoneAccessAuthorizer.get();
        }
        OzoneConfiguration conf = om.getConfiguration();
        Class<? extends IAccessAuthorizer> clazz = OzoneAuthorizerFactory.authorizerClass((ConfigurationSource)conf);
        if (OzoneAccessAuthorizer.class == clazz) {
            return OzoneAccessAuthorizer.get();
        }
        if (OzoneNativeAuthorizer.class == clazz) {
            OzoneNativeAuthorizer authorizer = new OzoneNativeAuthorizer();
            return OzoneAuthorizerFactory.configure(authorizer, om, km, pm);
        }
        IAccessAuthorizer authorizer = (IAccessAuthorizer)ReflectionUtils.newInstance(clazz, (Configuration)conf);
        return authorizer instanceof OzoneNativeAuthorizer ? OzoneAuthorizerFactory.configure((OzoneNativeAuthorizer)authorizer, om, km, pm) : authorizer;
    }

    private static IAccessAuthorizer configure(OzoneNativeAuthorizer authorizer, OzoneManager om, KeyManager km, PrefixManager pm) {
        authorizer.setVolumeManager(om.getVolumeManager());
        authorizer.setBucketManager(om.getBucketManager());
        authorizer.setKeyManager(km);
        authorizer.setPrefixManager(pm);
        authorizer.setAdminCheck(om::isAdmin);
        authorizer.setReadOnlyAdminCheck(om::isReadOnlyAdmin);
        authorizer.setAllowListAllVolumes(om.getAllowListAllVolumes());
        return authorizer;
    }

    private static Class<? extends IAccessAuthorizer> authorizerClass(ConfigurationSource conf) {
        return conf.getClass("ozone.acl.authorizer.class", OzoneAccessAuthorizer.class, IAccessAuthorizer.class);
    }
}

