/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.utils.BackgroundService;
import org.apache.hadoop.hdds.utils.BackgroundTask;
import org.apache.hadoop.hdds.utils.BackgroundTaskQueue;
import org.apache.hadoop.hdds.utils.BackgroundTaskResult;
import org.apache.hadoop.ozone.om.ExpiredOpenKeys;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OMRatisHelper;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerRatisServer;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.util.Time;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenKeyCleanupService
extends BackgroundService {
    private static final Logger LOG = LoggerFactory.getLogger(OpenKeyCleanupService.class);
    private static final int OPEN_KEY_DELETING_CORE_POOL_SIZE = 1;
    private final OzoneManager ozoneManager;
    private final KeyManager keyManager;
    private final ClientId clientId = ClientId.randomId();
    private final Duration expireThreshold;
    private final int cleanupLimitPerTask;
    private final AtomicLong submittedOpenKeyCount;
    private final AtomicLong runCount;
    private final AtomicBoolean suspended;

    public OpenKeyCleanupService(long interval, TimeUnit unit, long timeout, OzoneManager ozoneManager, ConfigurationSource conf) {
        super("OpenKeyCleanupService", interval, unit, 1, timeout, ozoneManager.getThreadNamePrefix());
        this.ozoneManager = ozoneManager;
        this.keyManager = ozoneManager.getKeyManager();
        long expireMillis = conf.getTimeDuration("ozone.om.open.key.expire.threshold", "7d", TimeUnit.MILLISECONDS);
        this.expireThreshold = Duration.ofMillis(expireMillis);
        this.cleanupLimitPerTask = conf.getInt("ozone.om.open.key.cleanup.limit.per.task", 1000);
        this.submittedOpenKeyCount = new AtomicLong(0L);
        this.runCount = new AtomicLong(0L);
        this.suspended = new AtomicBoolean(false);
    }

    @VisibleForTesting
    public long getRunCount() {
        return this.runCount.get();
    }

    @VisibleForTesting
    public void suspend() {
        this.suspended.set(true);
    }

    @VisibleForTesting
    public void resume() {
        this.suspended.set(false);
    }

    @VisibleForTesting
    public long getSubmittedOpenKeyCount() {
        return this.submittedOpenKeyCount.get();
    }

    public BackgroundTaskQueue getTasks() {
        BackgroundTaskQueue queue = new BackgroundTaskQueue();
        queue.add((BackgroundTask)new OpenKeyCleanupTask(BucketLayout.DEFAULT));
        queue.add((BackgroundTask)new OpenKeyCleanupTask(BucketLayout.FILE_SYSTEM_OPTIMIZED));
        return queue;
    }

    private boolean shouldRun() {
        return !this.suspended.get() && this.ozoneManager.isLeaderReady();
    }

    private boolean isRatisEnabled() {
        return this.ozoneManager.isRatisEnabled();
    }

    private class OpenKeyCleanupTask
    implements BackgroundTask {
        private final BucketLayout bucketLayout;

        OpenKeyCleanupTask(BucketLayout bucketLayout) {
            this.bucketLayout = bucketLayout;
        }

        public int getPriority() {
            return 0;
        }

        public BackgroundTaskResult call() throws Exception {
            OzoneManagerProtocolProtos.OMRequest omRequest;
            OzoneManagerProtocolProtos.OMResponse response;
            ExpiredOpenKeys expiredOpenKeys;
            if (!OpenKeyCleanupService.this.shouldRun()) {
                return BackgroundTaskResult.EmptyTaskResult.newResult();
            }
            OpenKeyCleanupService.this.runCount.incrementAndGet();
            long startTime = Time.monotonicNow();
            try {
                expiredOpenKeys = OpenKeyCleanupService.this.keyManager.getExpiredOpenKeys(OpenKeyCleanupService.this.expireThreshold, OpenKeyCleanupService.this.cleanupLimitPerTask, this.bucketLayout);
            }
            catch (IOException e) {
                LOG.error("Unable to get hanging open keys, retry in next interval", (Throwable)e);
                return BackgroundTaskResult.EmptyTaskResult.newResult();
            }
            Collection openKeyBuckets = expiredOpenKeys.getOpenKeyBuckets();
            int numOpenKeys = openKeyBuckets.stream().mapToInt(OzoneManagerProtocolProtos.OpenKeyBucket.Builder::getKeysCount).sum();
            if (!openKeyBuckets.isEmpty() && (response = this.submitRequest(omRequest = this.createDeleteOpenKeysRequest(openKeyBuckets.stream()))) != null && response.getSuccess()) {
                OpenKeyCleanupService.this.ozoneManager.getMetrics().incNumOpenKeysCleaned(numOpenKeys);
            }
            List hsyncKeys = expiredOpenKeys.getHsyncKeys();
            int numHsyncKeys = hsyncKeys.size();
            if (!hsyncKeys.isEmpty()) {
                hsyncKeys.forEach(b -> {
                    OzoneManagerProtocolProtos.OMResponse response = this.submitRequest(this.createCommitKeyRequest((OzoneManagerProtocolProtos.CommitKeyRequest.Builder)b));
                    if (response != null && response.getSuccess()) {
                        OpenKeyCleanupService.this.ozoneManager.getMetrics().incNumOpenKeysHSyncCleaned();
                    }
                });
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Number of expired open keys submitted for deletion: {}, for commit: {}, elapsed time: {}ms", new Object[]{numOpenKeys, numHsyncKeys, Time.monotonicNow() - startTime});
            }
            int numKeys = numOpenKeys + numHsyncKeys;
            OpenKeyCleanupService.this.submittedOpenKeyCount.addAndGet(numKeys);
            return () -> numKeys;
        }

        private OzoneManagerProtocolProtos.OMRequest createCommitKeyRequest(OzoneManagerProtocolProtos.CommitKeyRequest.Builder request) {
            return OzoneManagerProtocolProtos.OMRequest.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.CommitKey).setCommitKeyRequest(request).setClientId(OpenKeyCleanupService.this.clientId.toString()).build();
        }

        private OzoneManagerProtocolProtos.OMRequest createDeleteOpenKeysRequest(Stream<OzoneManagerProtocolProtos.OpenKeyBucket.Builder> openKeyBuckets) {
            OzoneManagerProtocolProtos.DeleteOpenKeysRequest.Builder request = OzoneManagerProtocolProtos.DeleteOpenKeysRequest.newBuilder().setBucketLayout(this.bucketLayout.toProto());
            openKeyBuckets.forEach(arg_0 -> ((OzoneManagerProtocolProtos.DeleteOpenKeysRequest.Builder)request).addOpenKeysPerBucket(arg_0));
            OzoneManagerProtocolProtos.OMRequest omRequest = OzoneManagerProtocolProtos.OMRequest.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.DeleteOpenKeys).setDeleteOpenKeysRequest(request).setClientId(OpenKeyCleanupService.this.clientId.toString()).build();
            return omRequest;
        }

        private OzoneManagerProtocolProtos.OMResponse submitRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
            try {
                if (OpenKeyCleanupService.this.isRatisEnabled()) {
                    OzoneManagerRatisServer server = OpenKeyCleanupService.this.ozoneManager.getOmRatisServer();
                    RaftClientRequest raftClientRequest = RaftClientRequest.newBuilder().setClientId(OpenKeyCleanupService.this.clientId).setServerId(server.getRaftPeerId()).setGroupId(server.getRaftGroupId()).setCallId(OpenKeyCleanupService.this.runCount.get()).setMessage(Message.valueOf((ByteString)OMRatisHelper.convertRequestToByteString((OzoneManagerProtocolProtos.OMRequest)omRequest))).setType(RaftClientRequest.writeRequestType()).build();
                    return server.submitRequest(omRequest, raftClientRequest);
                }
                return OpenKeyCleanupService.this.ozoneManager.getOmServerProtocol().submitRequest(null, omRequest);
            }
            catch (ServiceException e) {
                LOG.error("Open key " + omRequest.getCmdType() + " request failed. Will retry at next run.", (Throwable)e);
                return null;
            }
        }
    }
}

