/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.snapshot;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.RDBStore;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OmSnapshot;
import org.apache.hadoop.ozone.om.OmSnapshotManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.snapshot.ReferenceCounted;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"snapshotInfoTable"})
public class OMSnapshotMoveDeletedKeysResponse
extends OMClientResponse {
    private SnapshotInfo fromSnapshot;
    private SnapshotInfo nextSnapshot;
    private List<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos> nextDBKeysList;
    private List<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos> reclaimKeysList;
    private List<HddsProtos.KeyValue> renamedKeysList;
    private List<String> movedDirs;

    public OMSnapshotMoveDeletedKeysResponse(OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull SnapshotInfo fromSnapshot, SnapshotInfo nextSnapshot, List<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos> nextDBKeysList, List<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos> reclaimKeysList, List<HddsProtos.KeyValue> renamedKeysList, List<String> movedDirs) {
        super(omResponse);
        this.fromSnapshot = fromSnapshot;
        this.nextSnapshot = nextSnapshot;
        this.nextDBKeysList = nextDBKeysList;
        this.reclaimKeysList = reclaimKeysList;
        this.renamedKeysList = renamedKeysList;
        this.movedDirs = movedDirs;
    }

    public OMSnapshotMoveDeletedKeysResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    protected void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        OmSnapshotManager omSnapshotManager = ((OmMetadataManagerImpl)omMetadataManager).getOzoneManager().getOmSnapshotManager();
        Throwable throwable = null;
        Object var5_6 = null;
        try (ReferenceCounted<OmSnapshot> rcOmFromSnapshot = omSnapshotManager.getSnapshot(this.fromSnapshot.getSnapshotId());){
            Throwable throwable2;
            OmSnapshot fromOmSnapshot;
            block37: {
                fromOmSnapshot = rcOmFromSnapshot.get();
                if (this.nextSnapshot != null) {
                    Throwable throwable3 = null;
                    throwable2 = null;
                    try (ReferenceCounted<OmSnapshot> rcOmNextSnapshot = omSnapshotManager.getSnapshot(this.nextSnapshot.getSnapshotId());){
                        OmSnapshot nextOmSnapshot = rcOmNextSnapshot.get();
                        RDBStore nextSnapshotStore = (RDBStore)nextOmSnapshot.getMetadataManager().getStore();
                        Throwable throwable4 = null;
                        Object var14_21 = null;
                        try (BatchOperation writeBatch = nextSnapshotStore.initBatchOperation();){
                            this.processKeys(writeBatch, nextOmSnapshot.getMetadataManager());
                            this.processDirs(writeBatch, nextOmSnapshot.getMetadataManager(), fromOmSnapshot);
                            nextSnapshotStore.commitBatchOperation(writeBatch);
                            nextSnapshotStore.getDb().flushWal(true);
                            nextSnapshotStore.getDb().flush();
                            break block37;
                        }
                        catch (Throwable throwable5) {
                            if (throwable4 == null) {
                                throwable4 = throwable5;
                            } else if (throwable4 != throwable5) {
                                throwable4.addSuppressed(throwable5);
                            }
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable6) {
                        if (throwable3 == null) {
                            throwable3 = throwable6;
                        } else if (throwable3 != throwable6) {
                            throwable3.addSuppressed(throwable6);
                        }
                        throw throwable3;
                    }
                }
                this.processKeys(batchOperation, omMetadataManager);
                this.processDirs(batchOperation, omMetadataManager, fromOmSnapshot);
            }
            RDBStore fromSnapshotStore = (RDBStore)fromOmSnapshot.getMetadataManager().getStore();
            throwable2 = null;
            Object var10_15 = null;
            try (BatchOperation fromSnapshotBatchOp = fromSnapshotStore.initBatchOperation();){
                this.processReclaimKeys(fromSnapshotBatchOp, fromOmSnapshot.getMetadataManager());
                this.deleteDirsFromSnapshot(fromSnapshotBatchOp, fromOmSnapshot);
                fromSnapshotStore.commitBatchOperation(fromSnapshotBatchOp);
                fromSnapshotStore.getDb().flushWal(true);
                fromSnapshotStore.getDb().flush();
            }
            catch (Throwable throwable7) {
                if (throwable2 == null) {
                    throwable2 = throwable7;
                } else if (throwable2 != throwable7) {
                    throwable2.addSuppressed(throwable7);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable8) {
            if (throwable == null) {
                throwable = throwable8;
            } else if (throwable != throwable8) {
                throwable.addSuppressed(throwable8);
            }
            throw throwable;
        }
    }

    private void deleteDirsFromSnapshot(BatchOperation batchOp, OmSnapshot fromOmSnapshot) throws IOException {
        for (String movedDirsKey : this.movedDirs) {
            fromOmSnapshot.getMetadataManager().getDeletedDirTable().deleteWithBatch(batchOp, (Object)movedDirsKey);
        }
    }

    private void processReclaimKeys(BatchOperation batchOp, OMMetadataManager metadataManager) throws IOException {
        for (OzoneManagerProtocolProtos.SnapshotMoveKeyInfos dBKey : this.reclaimKeysList) {
            RepeatedOmKeyInfo omKeyInfos = OMSnapshotMoveDeletedKeysResponse.createRepeatedOmKeyInfo(dBKey.getKeyInfosList());
            if (omKeyInfos == null) {
                metadataManager.getDeletedTable().deleteWithBatch(batchOp, (Object)dBKey.getKey());
                continue;
            }
            metadataManager.getDeletedTable().putWithBatch(batchOp, (Object)dBKey.getKey(), (Object)omKeyInfos);
        }
    }

    private void processDirs(BatchOperation batchOp, OMMetadataManager omMetadataManager, OmSnapshot fromOmSnapshot) throws IOException {
        for (String movedDirsKey : this.movedDirs) {
            OmKeyInfo keyInfo = (OmKeyInfo)fromOmSnapshot.getMetadataManager().getDeletedDirTable().get((Object)movedDirsKey);
            if (keyInfo == null) continue;
            omMetadataManager.getDeletedDirTable().putWithBatch(batchOp, (Object)movedDirsKey, (Object)keyInfo);
        }
    }

    private void processKeys(BatchOperation batchOp, OMMetadataManager metadataManager) throws IOException {
        for (HddsProtos.KeyValue renamedKey : this.renamedKeysList) {
            metadataManager.getSnapshotRenamedTable().putWithBatch(batchOp, (Object)renamedKey.getKey(), (Object)renamedKey.getValue());
        }
        for (OzoneManagerProtocolProtos.SnapshotMoveKeyInfos dBKey : this.nextDBKeysList) {
            RepeatedOmKeyInfo omKeyInfos = this.createRepeatedOmKeyInfo(dBKey, metadataManager);
            if (omKeyInfos == null) continue;
            metadataManager.getDeletedTable().putWithBatch(batchOp, (Object)dBKey.getKey(), (Object)omKeyInfos);
        }
    }

    public static RepeatedOmKeyInfo createRepeatedOmKeyInfo(List<OzoneManagerProtocolProtos.KeyInfo> keyInfoList) throws IOException {
        RepeatedOmKeyInfo result = null;
        for (OzoneManagerProtocolProtos.KeyInfo keyInfo : keyInfoList) {
            if (result == null) {
                result = new RepeatedOmKeyInfo(OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)keyInfo));
                continue;
            }
            result.addOmKeyInfo(OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)keyInfo));
        }
        return result;
    }

    private RepeatedOmKeyInfo createRepeatedOmKeyInfo(OzoneManagerProtocolProtos.SnapshotMoveKeyInfos snapshotMoveKeyInfos, OMMetadataManager metadataManager) throws IOException {
        String dbKey = snapshotMoveKeyInfos.getKey();
        List keyInfoList = snapshotMoveKeyInfos.getKeyInfosList();
        RepeatedOmKeyInfo result = (RepeatedOmKeyInfo)metadataManager.getDeletedTable().get((Object)dbKey);
        for (OzoneManagerProtocolProtos.KeyInfo keyInfo : keyInfoList) {
            OmKeyInfo omKeyInfo = OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)keyInfo);
            if (result == null) {
                result = new RepeatedOmKeyInfo(omKeyInfo);
                continue;
            }
            if (this.isSameAsLatestOmKeyInfo(omKeyInfo, result)) continue;
            result.addOmKeyInfo(omKeyInfo);
        }
        return result;
    }

    private boolean isSameAsLatestOmKeyInfo(OmKeyInfo omKeyInfo, RepeatedOmKeyInfo result) {
        int size = result.getOmKeyInfoList().size();
        assert (size > 0);
        OmKeyInfo keyInfoFromRepeated = (OmKeyInfo)result.getOmKeyInfoList().get(size - 1);
        return omKeyInfo.equals((Object)keyInfoFromRepeated);
    }
}

