/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.tenant;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmDBAccessIdInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"tenantAccessIdTable"})
public class OMTenantRevokeAdminResponse
extends OMClientResponse {
    private String accessId;
    private OmDBAccessIdInfo omDBAccessIdInfo;

    public OMTenantRevokeAdminResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull String accessId, @Nonnull OmDBAccessIdInfo omDBAccessIdInfo) {
        super(omResponse);
        this.accessId = accessId;
        this.omDBAccessIdInfo = omDBAccessIdInfo;
    }

    public OMTenantRevokeAdminResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        omMetadataManager.getTenantAccessIdTable().putWithBatch(batchOperation, (Object)this.accessId, (Object)this.omDBAccessIdInfo);
    }

    @VisibleForTesting
    public OmDBAccessIdInfo getOmDBAccessIdInfo() {
        return this.omDBAccessIdInfo;
    }
}

