/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key.acl.prefix;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmPrefixInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"prefixTable"})
public class OMPrefixAclResponse
extends OMClientResponse {
    private OmPrefixInfo prefixInfo;

    public OMPrefixAclResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull OmPrefixInfo omPrefixInfo) {
        super(omResponse);
        this.prefixInfo = omPrefixInfo;
    }

    public OMPrefixAclResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.getOMResponse().hasRemoveAclResponse() && this.prefixInfo.getAcls().size() == 0) {
            omMetadataManager.getPrefixTable().deleteWithBatch(batchOperation, (Object)this.prefixInfo.getName());
        } else {
            omMetadataManager.getPrefixTable().putWithBatch(batchOperation, (Object)this.prefixInfo.getName(), (Object)this.prefixInfo);
        }
    }
}

