/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key.acl;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.key.acl.OMKeyAclResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.jetbrains.annotations.NotNull;

@CleanupTableInfo(cleanupTables={"fileTable", "directoryTable"})
public class OMKeyAclResponseWithFSO
extends OMKeyAclResponse {
    private boolean isDirectory;
    private long volumeId;
    private long bucketId;

    public OMKeyAclResponseWithFSO(@NotNull OzoneManagerProtocolProtos.OMResponse omResponse, @NotNull OmKeyInfo omKeyInfo, boolean isDirectory, @Nonnull BucketLayout bucketLayout, @Nonnull long volumeId, @Nonnull long bucketId) {
        super(omResponse, omKeyInfo, bucketLayout);
        this.isDirectory = isDirectory;
        this.volumeId = volumeId;
        this.bucketId = bucketId;
    }

    public OMKeyAclResponseWithFSO(@NotNull OzoneManagerProtocolProtos.OMResponse omResponse, BucketLayout bucketLayout) {
        super(omResponse, bucketLayout);
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String ozoneDbKey = omMetadataManager.getOzonePathKey(this.volumeId, this.bucketId, this.getOmKeyInfo().getParentObjectID(), this.getOmKeyInfo().getFileName());
        if (this.isDirectory) {
            OmDirectoryInfo dirInfo = OMFileRequest.getDirectoryInfo(this.getOmKeyInfo());
            omMetadataManager.getDirectoryTable().putWithBatch(batchOperation, (Object)ozoneDbKey, (Object)dirInfo);
        } else {
            omMetadataManager.getKeyTable(this.getBucketLayout()).putWithBatch(batchOperation, (Object)ozoneDbKey, (Object)this.getOmKeyInfo());
        }
    }
}

