/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.key.OMKeysDeleteResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.jetbrains.annotations.NotNull;

@CleanupTableInfo(cleanupTables={"fileTable", "directoryTable", "deletedDirectoryTable", "deletedTable", "bucketTable"})
public class OMKeysDeleteResponseWithFSO
extends OMKeysDeleteResponse {
    private List<OmKeyInfo> dirsList;
    private long volumeId;

    public OMKeysDeleteResponseWithFSO(@NotNull OzoneManagerProtocolProtos.OMResponse omResponse, @NotNull List<OmKeyInfo> keyDeleteList, @NotNull List<OmKeyInfo> dirDeleteList, boolean isRatisEnabled, @NotNull OmBucketInfo omBucketInfo, @Nonnull long volId) {
        super(omResponse, keyDeleteList, isRatisEnabled, omBucketInfo);
        this.dirsList = dirDeleteList;
        this.volumeId = volId;
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String ozoneDbKey;
        Table keyTable = omMetadataManager.getKeyTable(this.getBucketLayout());
        long bucketId = this.getOmBucketInfo().getObjectID();
        for (OmKeyInfo omKeyInfo : this.dirsList) {
            ozoneDbKey = omMetadataManager.getOzonePathKey(this.volumeId, bucketId, omKeyInfo.getParentObjectID(), omKeyInfo.getFileName());
            omMetadataManager.getDirectoryTable().deleteWithBatch(batchOperation, (Object)ozoneDbKey);
            String ozoneDeleteKey = omMetadataManager.getOzoneDeletePathKey(omKeyInfo.getObjectID(), ozoneDbKey);
            omMetadataManager.getDeletedDirTable().putWithBatch(batchOperation, (Object)ozoneDeleteKey, (Object)omKeyInfo);
        }
        for (OmKeyInfo omKeyInfo : this.getOmKeyInfoList()) {
            ozoneDbKey = omMetadataManager.getOzonePathKey(this.volumeId, bucketId, omKeyInfo.getParentObjectID(), omKeyInfo.getFileName());
            String deletedKey = omMetadataManager.getOzoneKey(omKeyInfo.getVolumeName(), omKeyInfo.getBucketName(), omKeyInfo.getKeyName());
            deletedKey = omMetadataManager.getOzoneDeletePathKey(omKeyInfo.getObjectID(), deletedKey);
            this.addDeletionToBatch(omMetadataManager, batchOperation, keyTable, ozoneDbKey, deletedKey, omKeyInfo);
        }
        omMetadataManager.getBucketTable().putWithBatch(batchOperation, (Object)omMetadataManager.getBucketKey(this.getOmBucketInfo().getVolumeName(), this.getOmBucketInfo().getBucketName()), (Object)this.getOmBucketInfo());
    }

    @Override
    public BucketLayout getBucketLayout() {
        return BucketLayout.FILE_SYSTEM_OPTIMIZED;
    }
}

