/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.bucket;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"bucketTable", "volumeTable"})
public final class OMBucketCreateResponse
extends OMClientResponse {
    private final OmBucketInfo omBucketInfo;
    private final OmVolumeArgs omVolumeArgs;

    public OMBucketCreateResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull OmBucketInfo omBucketInfo, @Nonnull OmVolumeArgs omVolumeArgs) {
        super(omResponse);
        this.omBucketInfo = omBucketInfo;
        this.omVolumeArgs = omVolumeArgs;
    }

    public OMBucketCreateResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull OmBucketInfo omBucketInfo) {
        super(omResponse);
        this.omBucketInfo = omBucketInfo;
        this.omVolumeArgs = null;
    }

    public OMBucketCreateResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
        this.omBucketInfo = null;
        this.omVolumeArgs = null;
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String dbBucketKey = omMetadataManager.getBucketKey(this.omBucketInfo.getVolumeName(), this.omBucketInfo.getBucketName());
        omMetadataManager.getBucketTable().putWithBatch(batchOperation, (Object)dbBucketKey, (Object)this.omBucketInfo);
        if (this.omVolumeArgs != null) {
            omMetadataManager.getVolumeTable().putWithBatch(batchOperation, (Object)omMetadataManager.getVolumeKey(this.omVolumeArgs.getVolume()), (Object)this.omVolumeArgs);
        }
    }

    @Nullable
    public OmBucketInfo getOmBucketInfo() {
        return this.omBucketInfo;
    }
}

