/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneConfigUtil;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.file.OMDirectoryCreateRequestWithFSO;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyCreateRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyCreateResponseWithFSO;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;

public class OMKeyCreateRequestWithFSO
extends OMKeyCreateRequest {
    public OMKeyCreateRequestWithFSO(OzoneManagerProtocolProtos.OMRequest omRequest, BucketLayout bucketLayout) {
        super(omRequest, bucketLayout);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex) {
        OMClientRequest.Result result;
        int numKeysCreated;
        Exception exception;
        OMClientResponse omClientResponse;
        OMMetrics omMetrics;
        Map<String, String> auditMap;
        OzoneManagerProtocolProtos.CreateKeyRequest createKeyRequest;
        block14: {
            createKeyRequest = this.getOmRequest().getCreateKeyRequest();
            OzoneManagerProtocolProtos.KeyArgs keyArgs = createKeyRequest.getKeyArgs();
            auditMap = this.buildKeyArgsAuditMap(keyArgs);
            String volumeName = keyArgs.getVolumeName();
            String bucketName = keyArgs.getBucketName();
            String keyName = keyArgs.getKeyName();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumKeyAllocates();
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            OmBucketInfo omBucketInfo = null;
            ArrayList<OmKeyLocationInfo> locations = new ArrayList<OmKeyLocationInfo>();
            boolean acquireLock = false;
            omClientResponse = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            exception = null;
            numKeysCreated = 0;
            try {
                try {
                    keyArgs = this.resolveBucketLink(ozoneManager, keyArgs, auditMap);
                    volumeName = keyArgs.getVolumeName();
                    bucketName = keyArgs.getBucketName();
                    this.checkKeyAcls(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.CREATE, OzoneObj.ResourceType.KEY);
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    acquireLock = this.getOmLockDetails().isLockAcquired();
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    long volumeId = ((OmVolumeArgs)omMetadataManager.getVolumeTable().get((Object)omMetadataManager.getVolumeKey(volumeName))).getObjectID();
                    long bucketId = ((OmBucketInfo)omMetadataManager.getBucketTable().get((Object)omMetadataManager.getBucketKey(volumeName, bucketName))).getObjectID();
                    OmKeyInfo dbFileInfo = null;
                    OMFileRequest.OMPathInfoWithFSO pathInfoFSO = OMFileRequest.verifyDirectoryKeysInPath(omMetadataManager, volumeName, bucketName, keyName, Paths.get(keyName, new String[0]));
                    if (pathInfoFSO.getDirectoryResult() == OMFileRequest.OMDirectoryResult.FILE_EXISTS) {
                        String dbFileKey = omMetadataManager.getOzonePathKey(volumeId, bucketId, pathInfoFSO.getLastKnownParentId(), pathInfoFSO.getLeafNodeName());
                        dbFileInfo = OMFileRequest.getOmKeyInfoFromFileTable(false, omMetadataManager, dbFileKey, keyName);
                    }
                    if (pathInfoFSO.getDirectoryResult() == OMFileRequest.OMDirectoryResult.DIRECTORY_EXISTS) {
                        throw new OMException("Cannot write to directory. createIntermediateDirs behavior is enabled and hence / has special interpretation: " + keyName, OMException.ResultCodes.NOT_A_FILE);
                    }
                    if (pathInfoFSO.getDirectoryResult() == OMFileRequest.OMDirectoryResult.FILE_EXISTS_IN_GIVENPATH) {
                        throw new OMException("Can not create file: " + keyName + " as there is already file in the given path", OMException.ResultCodes.NOT_A_FILE);
                    }
                    OmBucketInfo bucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)omMetadataManager.getBucketKey(volumeName, bucketName));
                    List<OmDirectoryInfo> missingParentInfos = OMDirectoryCreateRequestWithFSO.getAllMissingParentDirInfo(ozoneManager, keyArgs, bucketInfo, pathInfoFSO, trxnLogIndex);
                    numKeysCreated = missingParentInfos.size();
                    ReplicationConfig repConfig = OzoneConfigUtil.resolveReplicationConfigPreference(keyArgs.getType(), keyArgs.getFactor(), keyArgs.getEcReplicationConfig(), bucketInfo.getDefaultReplicationConfig(), ozoneManager);
                    OmKeyInfo omFileInfo = this.prepareFileInfo(omMetadataManager, keyArgs, dbFileInfo, keyArgs.getDataSize(), locations, this.getFileEncryptionInfo(keyArgs), ozoneManager.getPrefixManager(), bucketInfo, pathInfoFSO, trxnLogIndex, pathInfoFSO.getLeafNodeObjectId(), ozoneManager.isRatisEnabled(), repConfig);
                    long openVersion = omFileInfo.getLatestVersionLocations().getVersion();
                    long clientID = createKeyRequest.getClientID();
                    String dbOpenFileName = omMetadataManager.getOpenFileName(volumeId, bucketId, pathInfoFSO.getLastKnownParentId(), pathInfoFSO.getLeafNodeName(), clientID);
                    List newLocationList = keyArgs.getKeyLocationsList().stream().map(OmKeyLocationInfo::getFromProtobuf).collect(Collectors.toList());
                    omFileInfo.appendNewBlocks(newLocationList, false);
                    omBucketInfo = this.getBucketInfo(omMetadataManager, volumeName, bucketName);
                    long preAllocatedSpace = (long)newLocationList.size() * ozoneManager.getScmBlockSize() * (long)repConfig.getRequiredNodes();
                    this.checkBucketQuotaInBytes(omMetadataManager, omBucketInfo, preAllocatedSpace);
                    this.checkBucketQuotaInNamespace(omBucketInfo, (long)numKeysCreated + 1L);
                    omBucketInfo.incrUsedNamespace((long)numKeysCreated);
                    OMFileRequest.addOpenFileTableCacheEntry(omMetadataManager, dbOpenFileName, omFileInfo, pathInfoFSO.getLeafNodeName(), trxnLogIndex);
                    OMFileRequest.addDirectoryTableCacheEntries(omMetadataManager, volumeId, bucketId, trxnLogIndex, missingParentInfos, null);
                    int clientVersion = this.getOmRequest().getVersion();
                    omResponse.setCreateKeyResponse(OzoneManagerProtocolProtos.CreateKeyResponse.newBuilder().setKeyInfo(omFileInfo.getNetworkProtobuf(keyName, clientVersion, keyArgs.getLatestVersionLocation())).setID(clientID).setOpenVersion(openVersion).build()).setCmdType(OzoneManagerProtocolProtos.Type.CreateKey);
                    omClientResponse = new OMKeyCreateResponseWithFSO(omResponse.build(), omFileInfo, missingParentInfos, clientID, omBucketInfo.copyObject(), volumeId);
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException | InvalidPathException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omMetrics.incNumKeyAllocateFails();
                    omResponse.setCmdType(OzoneManagerProtocolProtos.Type.CreateKey);
                    omClientResponse = new OMKeyCreateResponseWithFSO(this.createErrorOMResponse(omResponse, exception), this.getBucketLayout());
                    if (acquireLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (acquireLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (acquireLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage(OMAction.ALLOCATE_KEY, auditMap, exception, this.getOmRequest().getUserInfo()));
        this.logResult(createKeyRequest, omMetrics, exception, result, numKeysCreated);
        return omClientResponse;
    }

    @Override
    protected String getDBMultipartOpenKey(String volumeName, String bucketName, String keyName, String uploadID, OMMetadataManager omMetadataManager) throws IOException {
        long volumeId = omMetadataManager.getVolumeId(volumeName);
        long bucketId = omMetadataManager.getBucketId(volumeName, bucketName);
        long parentId = OMFileRequest.getParentId(omMetadataManager, volumeName, bucketName, keyName);
        String fileName = OzoneFSUtils.getFileName((String)keyName);
        return omMetadataManager.getMultipartKey(volumeId, bucketId, parentId, fileName, uploadID);
    }
}

