/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.helpers.QuotaUtil;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.OMAllocateBlockRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMAllocateBlockResponseWithFSO;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMAllocateBlockRequestWithFSO
extends OMAllocateBlockRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMAllocateBlockRequestWithFSO.class);

    public OMAllocateBlockRequestWithFSO(OzoneManagerProtocolProtos.OMRequest omRequest, BucketLayout bucketLayout) {
        super(omRequest, bucketLayout);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex) {
        Exception exception;
        OMClientResponse omClientResponse;
        Map<String, String> auditMap;
        AuditLogger auditLogger;
        block12: {
            OzoneManagerProtocolProtos.AllocateBlockRequest allocateBlockRequest = this.getOmRequest().getAllocateBlockRequest();
            OzoneManagerProtocolProtos.KeyArgs keyArgs = allocateBlockRequest.getKeyArgs();
            OzoneManagerProtocolProtos.KeyLocation blockLocation = allocateBlockRequest.getKeyLocation();
            Preconditions.checkNotNull((Object)blockLocation);
            String volumeName = keyArgs.getVolumeName();
            String bucketName = keyArgs.getBucketName();
            String keyName = keyArgs.getKeyName();
            long clientID = allocateBlockRequest.getClientID();
            OMMetrics omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumBlockAllocateCalls();
            auditLogger = ozoneManager.getAuditLogger();
            auditMap = this.buildKeyArgsAuditMap(keyArgs);
            auditMap.put("clientID", String.valueOf(clientID));
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            String openKeyName = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            omClientResponse = null;
            OmKeyInfo openKeyInfo = null;
            exception = null;
            OmBucketInfo omBucketInfo = null;
            boolean acquiredLock = false;
            try {
                try {
                    keyArgs = this.resolveBucketLink(ozoneManager, keyArgs, auditMap);
                    volumeName = keyArgs.getVolumeName();
                    bucketName = keyArgs.getBucketName();
                    this.checkKeyAclsInOpenKeyTable(ozoneManager, volumeName, bucketName, keyName, IAccessAuthorizer.ACLType.WRITE, allocateBlockRequest.getClientID());
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    openKeyName = this.getOpenKeyName(volumeName, bucketName, keyName, clientID, ozoneManager);
                    openKeyInfo = this.getOpenKeyInfo(omMetadataManager, openKeyName, keyName);
                    if (openKeyInfo == null) {
                        throw new OMException("Open Key not found " + openKeyName, OMException.ResultCodes.KEY_NOT_FOUND);
                    }
                    List<OmKeyLocationInfo> newLocationList = Collections.singletonList(OmKeyLocationInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyLocation)blockLocation));
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    acquiredLock = this.getOmLockDetails().isLockAcquired();
                    omBucketInfo = this.getBucketInfo(omMetadataManager, volumeName, bucketName);
                    long preAllocatedKeySize = (long)newLocationList.size() * ozoneManager.getScmBlockSize();
                    long hadAllocatedKeySize = (long)openKeyInfo.getLatestVersionLocations().getLocationList().size() * ozoneManager.getScmBlockSize();
                    ReplicationConfig repConfig = openKeyInfo.getReplicationConfig();
                    long totalAllocatedSpace = QuotaUtil.getReplicatedSize((long)preAllocatedKeySize, (ReplicationConfig)repConfig) + QuotaUtil.getReplicatedSize((long)hadAllocatedKeySize, (ReplicationConfig)repConfig);
                    this.checkBucketQuotaInBytes(omMetadataManager, omBucketInfo, totalAllocatedSpace);
                    openKeyInfo.appendNewBlocks(newLocationList, false);
                    openKeyInfo.setModificationTime(keyArgs.getModificationTime());
                    openKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
                    this.addOpenTableCacheEntry(trxnLogIndex, omMetadataManager, openKeyName, openKeyInfo);
                    omResponse.setAllocateBlockResponse(OzoneManagerProtocolProtos.AllocateBlockResponse.newBuilder().setKeyLocation(blockLocation).build());
                    long volumeId = omMetadataManager.getVolumeId(volumeName);
                    omClientResponse = this.getOmClientResponse(clientID, omResponse, openKeyInfo, omBucketInfo.copyObject(), volumeId);
                    LOG.debug("Allocated block for Volume:{}, Bucket:{}, OpenKey:{}", new Object[]{volumeName, bucketName, openKeyName});
                }
                catch (IOException | InvalidPathException ex) {
                    omMetrics.incNumBlockAllocateCallFails();
                    exception = ex;
                    omClientResponse = new OMAllocateBlockResponseWithFSO(this.createErrorOMResponse(omResponse, exception), this.getBucketLayout());
                    LOG.error("Allocate Block failed. Volume:{}, Bucket:{}, OpenKey:{}. Exception:{}", new Object[]{volumeName, bucketName, openKeyName, exception});
                    if (acquiredLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (acquiredLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (acquiredLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        this.auditLog(auditLogger, this.buildAuditMessage(OMAction.ALLOCATE_BLOCK, auditMap, exception, this.getOmRequest().getUserInfo()));
        return omClientResponse;
    }

    private OmKeyInfo getOpenKeyInfo(OMMetadataManager omMetadataManager, String openKeyName, String keyName) throws IOException {
        String fileName = OzoneFSUtils.getFileName((String)keyName);
        return OMFileRequest.getOmKeyInfoFromFileTable(true, omMetadataManager, openKeyName, fileName);
    }

    private String getOpenKeyName(String volumeName, String bucketName, String keyName, long clientID, OzoneManager ozoneManager) throws IOException {
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        long volumeId = omMetadataManager.getVolumeId(volumeName);
        long bucketId = omMetadataManager.getBucketId(volumeName, bucketName);
        String fileName = OzoneFSUtils.getFileName((String)keyName);
        Iterator<Path> pathComponents = Paths.get(keyName, new String[0]).iterator();
        long parentID = OMFileRequest.getParentID(volumeId, bucketId, pathComponents, keyName, omMetadataManager);
        return omMetadataManager.getOpenFileName(volumeId, bucketId, parentID, fileName, clientID);
    }

    private void addOpenTableCacheEntry(long trxnLogIndex, OMMetadataManager omMetadataManager, String openKeyName, OmKeyInfo openKeyInfo) {
        String fileName = openKeyInfo.getFileName();
        OMFileRequest.addOpenFileTableCacheEntry(omMetadataManager, openKeyName, openKeyInfo, fileName, trxnLogIndex);
    }

    @NotNull
    private OMClientResponse getOmClientResponse(long clientID, OzoneManagerProtocolProtos.OMResponse.Builder omResponse, OmKeyInfo openKeyInfo, OmBucketInfo omBucketInfo, long volumeId) {
        return new OMAllocateBlockResponseWithFSO(omResponse.build(), openKeyInfo, clientID, this.getBucketLayout(), volumeId, omBucketInfo.getObjectID());
    }
}

