/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.bucket.acl;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.ResolvedBucket;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.ObjectParser;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.bucket.acl.OMBucketAclResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;

public abstract class OMBucketAclRequest
extends OMClientRequest {
    private final BiPredicate<List<OzoneAcl>, OmBucketInfo> omBucketAclOp;

    public OMBucketAclRequest(OzoneManagerProtocolProtos.OMRequest omRequest, BiPredicate<List<OzoneAcl>, OmBucketInfo> aclOp) {
        super(omRequest);
        this.omBucketAclOp = aclOp;
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        boolean operationResult;
        Exception exception;
        OMClientResponse omClientResponse;
        List<OzoneAcl> ozoneAcls;
        block20: {
            ozoneAcls = this.getAcls();
            OMMetrics omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumBucketUpdates();
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = this.onInit();
            omClientResponse = null;
            exception = null;
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            boolean lockAcquired = false;
            String volume = null;
            String bucket = null;
            operationResult = false;
            try {
                try {
                    ObjectParser objectParser = new ObjectParser(this.getPath(), OzoneManagerProtocolProtos.OzoneObj.ObjectType.BUCKET);
                    ResolvedBucket resolvedBucket = ozoneManager.resolveBucketLink((Pair<String, String>)Pair.of((Object)objectParser.getVolume(), (Object)objectParser.getBucket()));
                    volume = resolvedBucket.realVolume();
                    bucket = resolvedBucket.realBucket();
                    if (ozoneManager.getAclsEnabled()) {
                        this.checkAcls(ozoneManager, OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE_ACL, volume, bucket, null);
                    }
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket}));
                    lockAcquired = this.getOmLockDetails().isLockAcquired();
                    String dbBucketKey = omMetadataManager.getBucketKey(volume, bucket);
                    OmBucketInfo omBucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)dbBucketKey);
                    if (omBucketInfo == null) {
                        throw new OMException(OMException.ResultCodes.BUCKET_NOT_FOUND);
                    }
                    operationResult = this.omBucketAclOp.test(ozoneAcls, omBucketInfo);
                    omBucketInfo.setUpdateID(transactionLogIndex, ozoneManager.isRatisEnabled());
                    if (operationResult) {
                        long modificationTime = omBucketInfo.getModificationTime();
                        if (this.getOmRequest().getAddAclRequest().hasObj()) {
                            modificationTime = this.getOmRequest().getAddAclRequest().getModificationTime();
                        } else if (this.getOmRequest().getSetAclRequest().hasObj()) {
                            modificationTime = this.getOmRequest().getSetAclRequest().getModificationTime();
                        } else if (this.getOmRequest().getRemoveAclRequest().hasObj()) {
                            modificationTime = this.getOmRequest().getRemoveAclRequest().getModificationTime();
                        }
                        omBucketInfo = omBucketInfo.toBuilder().setModificationTime(modificationTime).build();
                        omMetadataManager.getBucketTable().addCacheEntry(new CacheKey((Object)dbBucketKey), CacheValue.get((long)transactionLogIndex, (Object)omBucketInfo));
                    }
                    omClientResponse = this.onSuccess(omResponse, omBucketInfo, operationResult);
                }
                catch (IOException | InvalidPathException ex) {
                    exception = ex;
                    omClientResponse = this.onFailure(omResponse, exception);
                    if (lockAcquired) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (lockAcquired) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (lockAcquired) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        OzoneObj obj = this.getObject();
        Map auditMap = obj.toAuditMap();
        if (ozoneAcls != null) {
            auditMap.put("acl", ozoneAcls.toString());
        }
        this.onComplete(operationResult, exception, ozoneManager.getMetrics(), ozoneManager.getAuditLogger(), auditMap);
        return omClientResponse;
    }

    abstract List<OzoneAcl> getAcls();

    abstract String getPath();

    abstract OzoneObj getObject();

    abstract OzoneManagerProtocolProtos.OMResponse.Builder onInit();

    abstract OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder var1, OmBucketInfo var2, boolean var3);

    OMClientResponse onFailure(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, Exception exception) {
        return new OMBucketAclResponse(this.createErrorOMResponse(omResponse, exception));
    }

    abstract void onComplete(boolean var1, Exception var2, OMMetrics var3, AuditLogger var4, Map<String, String> var5);
}

